var db = require("../helpers/dynamoDBHelpers.js");
var matchmaker = require("../matchmaker.js");
var matchmakingHelpers = require("../helpers/matchmakingHelpers.js");

async function testMatchmaker() {
    console.log("Testing matchmaker");

    let testChannelID = "testChannelID";
    let numTesters = matchmaker.MAX_PLAYERS_PER_GAME*2 + 1;
    let failed = false;

    let dbResponse = await db.dynamoPut(db.DynamoTables.LiveSessions, {
        channelID: testChannelID,
    });
    if (!dbResponse.success) {
        res.status(500).end();
        console.error("Error during testing!");
        return;
    }

    for (let i = 0; i < numTesters; i++) {
        dbResponse = await db.dynamoPut(db.DynamoTables.LivePlayers, {
            channelID: testChannelID,
            opaqueUserID: "testUser" + i,
            gameID: "-1",
            matchmakingStartTimestamp: Date.now(),
        });
        if (!dbResponse.success) {
            res.status(500).end();
            console.error("Error during testing!");
            return;
        }
    }

    await matchmaker.matchmakeAllChannels();

    let executeAfterMatchmaking = async function () {

        let playersMatchmaking = await matchmakingHelpers.getPlayersMatchmaking(testChannelID);
        if (!playersMatchmaking.success) {
            res.status(500).end();
            console.error("Error during testing!");
            return;
        }
        let expectedPlayersStillMatchmaking = 1;
        if (playersMatchmaking.count != expectedPlayersStillMatchmaking) {
            console.log("Expected "+expectedPlayersStillMatchmaking+" players still matchmaking but instead had "+playersMatchmaking.count);
            failed = true;
        }


        for (let i = 0; i < numTesters; i++) {
            dbResponse = await db.dynamoDelete(db.DynamoTables.LivePlayers, {
                channelID: testChannelID,
                opaqueUserID: "testUser" + i,
            });
            if (!dbResponse.success) {
                res.status(500).end();
                console.error("Error during testing!");
                return;
            }
        }

        dbResponse = await db.dynamoDelete(db.DynamoTables.LiveSessions, {
            channelID: testChannelID,
        });
        if (!dbResponse.success) {
            res.status(500).end();
            console.error("Error during testing!");
            return;
        }

        if (failed) {
            console.log("Failed test.");
        } else {
            console.log("Passed test.");
        }
        console.log("(You should kill this process now with CTRL-C)")
        return;

    };
    setTimeout(executeAfterMatchmaking, 1000);
}

testMatchmaker();