const express = require('express');
const app = express();
const bodyParser = require('body-parser');
const expressLogger = require('express-logger-unique-req-id');

// Middleware
const cors = require('cors');
const authenticationMiddleware = require('./middleware/authentication.js');
const streamerAuthenticationMiddleware = require('./middleware/streamerAuthentication.js');
const requestLoggingMiddleware = require('./middleware/requestLoggingMiddleware.js');

app.use(cors());
app.use(bodyParser.json());
expressLogger.initializeLogger(app);
app.use(requestLoggingMiddleware);
app.use(authenticationMiddleware);
app.use('/streamer', streamerAuthenticationMiddleware);

// 200 OK on root to pass the EC2 health check
app.get('/', function(req, res) { res.status(200).end(); });

// Routes
const streamerRouter = require('./routes/streamer.js');
app.use('/streamer', streamerRouter);
const viewerRouter = require('./routes/viewer.js');
app.use('/viewer', viewerRouter);
const commonRouter = require('./routes/common.js');
app.use('/common', commonRouter);

module.exports = app;