const fetch = require("node-fetch");
const queryString = require("query-string");
const constants = require("../helpers/constants");
const logger = require("../logger.js");

const TWITCH_USERS_URL = "https://api.twitch.tv/helix/users";
const TWITCH_CLIENT_ID = "d4uvtfdr04uq6raoenvj7m86gdk16v";

module.exports.translateUserIDsToDisplayNames = async function(players) {
    const response = {
        result: {},
        error: false
    };

    try {
        if (players.length > 0) {
            const getUsersResponse = await getUsers(players);
            const getUsersResponseJson = await getUsersResponse.json();
        
            getUsersResponseJson.data.forEach(userJson => {
                response.result[userJson.id] = userJson.display_name;
            })
        }
    
        return response;
    } catch (err) {
        logger.error(`Failed to translate Twitch user IDs to usernames: ${err}`);
        response.error = true;
        return response;
    }
}

function getUsers(players) {
    const queryParams = {id: []}

    players.forEach(player => {
        if (player.userID != null && player.userID != constants.NO_USER_ID) {
            queryParams.id.push(player.userID)
        }
    });

    const parameterizedUrl = `${TWITCH_USERS_URL}?${queryString.stringify(queryParams)}`;

    const headers = {
        "client-id": TWITCH_CLIENT_ID,
        "content-type": "application/json",
    };

    const options = {
        headers,
        method: "GET",
    };

    return fetch(parameterizedUrl, options);
}