const commonHelpers = require("../helpers/commonHelpers");
const logger = require("../logger.js");

module.exports = async function(req, res, next) {
    // verify that user is broadcaster
    if (res.locals.role != 'broadcaster') {
        const message = "User is not the channel's broadcaster.";
        logger.error(message);

        res.statusMessage = message;
        res.status(403).end();
        return;
    }
    
    // verify that channel is whitelisted for the game
    const channelWhitelistStatus = await commonHelpers.getChannelWhitelistStatus(res.locals.channelID);
    if (channelWhitelistStatus.error) {
        const message = "Error verifying channel whitelist status for the game.";
        logger.error(message);

        res.statusMessage = message;
        res.status(500).end();
        return;
    }
    if (!channelWhitelistStatus.isWhitelisted) {
        const message = "Channel is not whitelisted for the game.";
        logger.error(message);
        
        res.statusMessage = message;
        res.status(403).end();
        return;
    }
    
    return next();
}