Gateway Overview
=============

Samus Gateway is a web service which manages Twitch Prime operations on the Twitch network. It acts as a proxy to Amazon-network Samus services via [Subsidiary Web Services (SWS)](https://w.amazon.com/bin/view/Online_Proxy_Fleet/SWS) or TwitchProxyService (TProx) which currently include:
* SamusOfferService (SOS)
* SamusSubscriptionCreditService (SSCS)
* SamusContentEligibilityService (SCES)
* SamusOrderingService (SOrdS)
---

Gateway is composed of:
1. HTTP endpoint to hosting Samus APIs;
2. SQS workers subscribed for Prime status updates which calls internal APIs for granting and canceling Samus benefits.

API
===
These are the functionality Gateway provides today:

* Twitch marketing strings management;
* 3P account link management:
* Prime user settings on Twitch;
* Offers and entitlements management;
* Prime subscription credit management;
   
## Documentation
[API Documentation](api/api.md)

## Endpoints

| Stage      | Endpoint                                                                   |
|------------|----------------------------------------------------------------------------|
| Local      | http://localhost:8000                                                      |
| Staging    | http://staging-samus-gateway-env.ybgep8dqmz.us-west-2.elasticbeanstalk.com |
| Production | http://prod-samus-gateway-env.ybgep8dqmz.us-west-2.elasticbeanstalk.com    |

## Set Up

### Github account
 Go to [your account settings page](https://git.xarth.tv/settings/keys) and follow the instructions there to add a new SSH key to your account.

### Go workspace
 - Install go via the command below. **NOTE**: We recommend installing Go 1.11 in order to run integration tests successfully.

		brew install go@1.11 (version 1.11 is needed in order for the unit tests to pass for Gateway only)

 - Create a Go workspace folder in your home directory. Ex:

		mkdir /Users/$(whoami)/GoWorkspace

 - Set your environment variable for GOPATH (in your .bashrc, .zshrc, or etc.)

		export GOPATH=/Users/$(whoami)/GoWorkspace

 - Append GOPATH/bin to PATH environment variable

		export PATH=$PATH:$GOPATH/bin

 - To check if Go installed correctly, run `go version` from the commandline. This version should more than 1.6

 - Clone down Gateway source within the new gopath.

		go get code.justin.tv/samus/gateway

    **NOTE:** If you get `fatal: unable to update url base from redirection` or `ssh: connect to host git.xarth.tv port 22: Operation timed out` then you need to update your .ssh/config file
        
        cd
        vim .ssh/config

        Insert the following:
        
        host git-aws.internal.justin.tv git.xarth.tv
          ProxyJump <username>@bastion.git.xarth.tv

 - Directory structure will now look like this:

		/Users/$(whoami)/GoWorkspace/src/gateway

## Dependencies

**NOTE:** dep is deprecated and we should move to Go Modules. Glide is redundant and should not be used because Gateway uses dep.

TL;DR Run this command after pulling code or to fix dependency issues

```make dep```

DETAILS:

"Hey dep, please make sure that my project is in sync: that Gopkg.lock satisfies all the imports in my project, and all the rules in Gopkg.toml, and that vendor/ contains exactly what Gopkg.lock says it should."

Using dep ensure
There are four times when you'll run dep ensure:

- To add a new dependency
- To update an existing dependency
- To catch up after importing a package for the first time in your project, or removing the last import of a package in your project
- To catch up to a change to a rule in Gopkg.toml

If you're not sure if there have been changes to imports or Gopkg.toml rules, run dep check. It will tell you what is out of sync in your project. If anything is out of sync, running dep ensure will bring it back into line.

Adding a dependency:

Make sure you have the latest version of the `twitch-bastion-util` by running:
```
brew info twitch-bastion-util // Gives you your current version. 2.7.2 will not work anymore
brew update // Makes sure the latest version of twitch-bastion-util is available to install
brew upgrade twitch-bastion-util // Upgrades to latest
teleport-bastion disable
teleport-bastion enable
```
[How to onboard your user to the Teleport Bastion](https://wiki.xarth.tv/display/SEC/Teleport+Bastion)

To add the dependency: 
```
    dep ensure -add github.com/pkg/errors github.com/foo/bar
```

This should succeed, resulting in an updated Gopkg.lock and vendor/ directory, as well as injecting a best-guess version constraint for github.com/pkg/errors into our Gopkg.toml. But, it will also report a warning:

```
    "github.com/pkg/errors" is not imported by your project, and has been temporarily added to Gopkg.lock and vendor/.
    If you run "dep ensure" again before actually importing it, it will disappear from Gopkg.lock and vendor/.
```

As the warning suggests, you should introduce an import "github.com/pkg/errors" in your code, the sooner the better. If you don't, a later dep ensure run will interpret your newly-added dependency as unused, and automatically remove it from Gopkg.lock and vendor/. This also means that if you want to add multiple dependencies at once, you'll need to do it in a single command, rather than one after the other:

```
    dep ensure -add github.com/pkg/errors github.com/foo/bar
```

Dep works this way because it considers the import statements it discovers through static analysis of your project's code to be the canonical indicator of what dependencies must be present.

An easier way to add dependencies:

- Add the import to the file you are adding the dependency to
- Run `dep ensure`
- Check if the Gopkg.toml has been updated (if it hasn't then you'll need to go the `dep ensure -add` rout)

Updating dependencies:

Single dependency
```
    dep ensure -update github.com/foo/bar
```

All dependencies
```
    dep ensure -update
```

Source with more info: https://golang.github.io/dep/docs/daily-dep.html


### Required certificates
For cross network calls, there are two certificates required:
- **SWS certificate:** This secret key allows SWS to trust our identity when forwarding calls to it. These are rotated once a year and a ticket is cut to our team.
- **Amazon Certificate Authority (CA) certificate:** This public key allows us to trust SWS's identity when forwarding calls to it. These are rarely changed.
 Because Gateway is not located in Gitfarm, we can't directly access them from this package and provide different solutions described below.
 Our solutions currently aggregate the following certificates in an ordered chain:
 1. [amazon-ca-g3](https://code.amazon.com/packages/TargetPublishingService/blobs/mainline/--/etc/cacerts/amazon-ca-g3.pem)
 2. [amazon-ca-g4-acm1](https://code.amazon.com/packages/TargetPublishingService/blobs/mainline/--/etc/cacerts/amazon-ca-g4-acm1.pem)
 3. [amazon-ca-g4-acm2](https://code.amazon.com/packages/TargetPublishingService/blobs/mainline/--/etc/cacerts/amazon-ca-g4-acm2.pem)
 4. [amazon-ca-g4-legacy](https://code.amazon.com/packages/TargetPublishingService/blobs/mainline/--/etc/cacerts/amazon-ca-g4-legacy.pem)

The location to read these certificates from is specified in the *settings* folder.

#### To run Gateway locally
##### CA Certificate
The *amazon-ca-certs.pem* file is included in the *certificates* folder.

##### SWS Certificate
- Go to [https://odin.amazon.com/#view/materialSet/com.amazon.samus.gateway.certificates.sws_cert_key_chain](https://odin.amazon.com/#view/materialSet/com.amazon.samus.gateway.certificates.sws_cert_key_chain).
- Click the _Add a Destination_ button to add your host class to the set of machines allowed to access these credentials, e.g. `DEV-DSK-<yourAmazonAlias>`.
- SSH to your dev desktop. You will need to be on the Amazon network (wpa2) to do this.
- Execute the following command to store the certificate on your dev desktop. You may need to [add *envImprovement* to your classpath](https://sage.amazon.com/questions/290377) for it to work:
 
		odin-get -t Credential com.amazon.samus.gateway.certificates.sws_cert_key_chain > sws_cert_key_chain

- Copy the created *sws_cert_key_chain* file over to the machine on which you want to run Gateway locally. The final certificate location should be */private/var/app/sws_cert_key_chain*.
    - Tip: You can use an [`scp`](https://kb.iu.edu/d/agye) command on your local machine to retrieve the cert from your dev desktop and store it in the appropriate location. To do this:
        - Make sure you're on your local machine and on the Amazon network.
        - Create the */private/var/app* directory

                sudo mkdir /private & sudo mkdir /private/var & sudo mkdir /private/var/app

        - Copy the cert with the following scp command

                sudo scp <yourAmazonAlias>@<yourDevDesktopAlias>:sws_cert_key_chain /private/var/app/sws_cert_key_chain
                
#### To run Gateway in Staging or Production
##### CA Certificate
The staging and production CA certificates are both stored in and loaded from Twitch [Sandstorm](https://dashboard.xarth.tv/sandstorm/manage-secrets) (analogous to Odin) under the names:
- *samus/gateway/production/amazon-ca-g3.pem*
- *samus/gateway/staging/amazon-ca-g3.pem* 

**NOTE:** If you can't see any certificates, ask a team member to add you to the `team-samus` LDAP group.
**NOTE**: Although the PEM files have G3 in the name, they still aggregate multiple certificates.

##### SWS Certificate
 The staging and production SWS certificates are stored with the Twitch Commerce team Sandstorm under the names:
 - *commerce/payday/production/sws-prod-cert*
 - *commerce/payday/staging/SWS_BETA_CHAIN_CERT_KEY*

**NOTE:** The only time we need to look at these is during SWS certificate rotations. You can read about steps to in the SWS Certificate Rotation section below.
**NOTE:** If you can't find these certificates, ask a Commerce team member to add you to the `team-payday` LDAP group.

### Elastic Beanstalk
Application is created using ElasticBeanstalk and Twitch Create Service.
* [EB Config](.elasticbeanstalk). [Refer here.](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/eb3-config.html)
* [Twitch Create Service](https://git.xarth.tv/dta/tcs)

## Making a code change
 - Create a new branch: `git checkout -b <branch_name>`

 - Push changes to a remote branch: `git push origin <branch_name>`

 - Click _Compare and pull request_ on the GitHub website for your package.

 - Make changes and commit and push to the remote branch. 
 
    **NOTE:** Do not use `commit --amend --no-edit`, always push.
 
    **NOTE:** Make a separate branch/commit for your vendor changes if possible to avoid reviewers having to see massive file changes!
 
 - When you get all checks approved to your pull request, do "Squash and merge your changes"

 - Merging the PR to master will automatically start the Jenkins pipeline defined in the Jenkinsfile which includes running the integration tests
     
     ```
     NOTE: Docker has added a rate limit of 100 requests per six hours. If you see this error you will need to try to build later. If this is a major issue then we need to schedule work to pull the image from Amazon ECR Gallery.
 
     toomanyrequests: You have reached your pull rate limit. You may increase the limit by authenticating and upgrading: https://www.docker.com/increase-rate-limit
    ```
   
 ## Mockery
 We use [Mockery](https://github.com/vektra/mockery/) to generate mocks used for unit testing. Run the following commands to install Mockery using Homebrew:
 ```
    brew install vektra/tap/mockery
    brew upgrade mockery
```
If you do not use Homebrew or are not developing on Mac, follow instructions on the Mockery repo for installation.
### Generating mocks
Mockery can be used to generate interface mocks. Run the command `mockery --inpackage --dir path/to/package --name InterfaceToBeMocked` to generate a mock
of the `InterfaceToBeMocked` interface that will output into the same package & directory as the original interface. This is typically how we generate mocks
for Gateway. When adding or changing a function on an interface, it is best practice to also regenerate the mock for that interface and check it in with
your code change.

## Building, Compiling, Testing, Running
- In order to use the tools described in this section, you must install them as a one time setup step. We use Retool and the `tools.json` file to manage Go tools. Use the following commands to install them:
```
    go get -u github.com/twitchtv/retool
    retool sync
```

- Take a look at the Makefile to see the targets that are available. Examples:
```
    make fmt         // runs formatting on your Go files
    make lint        // checks for mechanical errors and ill-formatted conventions
    make release     // similar to brazil-build release, the target to run in preparation for a release candidate
    make server      // similar to brazil-build server (starts the service but must be on the Twitch VPN)
    make integration // runs the integration tests in integration_test/client_integration_test.go (must be on the Twitch VPN)
```

- Run tests and check code coverage using [GoConvey](https://github.com/smartystreets/goconvey)
- If you see "0 test assertions run", your Golang version is incompatible with GoConvey. Use Homebrew to uninstall your current Golang version and reinstall a version that works 
with GoConvey. At the time of writing, newer versions of Golang (1.12.5+) don't work with GoConvey, but older versions like (1.11.x) do. ` brew uninstall go && brew install go@1.11`
```
    make test
```

Run the server with:
```
    make server
```

**NOTE:** Even if you can run the server, calls outside of Amazon IPs will get denied (i.e. will not work from home).

Debugging
==========
### Debugging Sandstorm
In order to debug issues with sandstorm run: `sudo /usr/bin/sandstorm-agent run /etc/sandstorm-agent/`

### Accessing application logs
You can access the application logs via Cloudwatch in the Gateway account (samus-aws+samus-gateway@amazon.com). 
To access the prod application logs, go to the Cloudwatch logs page and open the `/aws/elasticbeanstalk/prod-samus-gateway-env/var/log/eb-docker/containers/eb-current-app/stdouterr.log` log group. You can then search for logs by host, or aggregate all logs by clicking "Search Log Group".
For more information on application logs, like how to use CloudWatch Insight, check out the [Gateway runbook](https://w.amazon.com/bin/view/Samus/Tech/SamusGateway/Runbook)

### SSHing into the Gateway hosts
Use Twitch-Bastion To SSH Into hosts:
```
    brew tap twitch/internal git@git.xarth.tv:common/homebrew-custom.git
    brew install twitch-bastion-util
    twitch-bastion enable
```

Then choose the IP address of the host:
```
    ssh <ip_address>
```

To determine the ip address of a host, you will need to go to the [EC2 Console](https://us-west-2.console.aws.amazon.com/ec2/v2/home?region=us-west-2#) and grab the `Private IP` Address values for the `prod-samus-gateway` grouping.

MISC Setup
==========
* Development:
    * SQS : **samus-gateway-development** subscribed to **Topic** `arn:aws:sns:us-west-2:536870266760:TwitchPrime-StatusChange-NA`

* Staging:
    * SQS : **samus-gateway-staging** and **samus-gateway-staging-DLQ** subscribed to **Topic** `arn:aws:sns:us-west-2:536870266760:TwitchPrime-StatusChange-NA`

* Production
    * SQS : **samus-gateway-production** and **samus-gateway-production-DLQ** subscribed to **Topic** `arn:aws:sns:us-east-1:699495308465:TwitchPrime-StatusChange-NA`

# Jenkins pipeline
[View Pipeline in Jenkins](https://jenkins-og.xarth.tv/job/samus/job/gateway/job/master/)

**NOTE: The `jenkinsfile` auto deploys to staging and prod after you merge the code to master in your PR. [The Deploy Tool](https://deploy.xarth.tv/#/samus/gateway) can still be used to manually deploy and revert changes from both the staging and prod environments.**
    
Our code is deployed using Jenkins pipelines.  The deployment process is modeled in the `Jenkinsfile`.  For every branch that is pushed to our Github, Jenkins will build, deploy the changes to staging and run the integration tests.  For the `master` branch, Jenkins will do all of the above as well as deploying to production.

The pipeline can only run for one branch at a time so that we don't have issues with staging and the integration tests.

AWS
===
AWS resources are located in the [samus-aws+samus-gateway@amazon.com](https://isengard.amazon.com/federate?account=948702324517&role=admin) account in Isengard.
Both staging and production data are in this account. For the account links, tables are:
* *Prod* - [account_links_prod](https://isengard.amazon.com/federate?account=948702324517&role=admin&destination=dynamodb/home%3Fregion%3Dus-west-2%23tables%3Aselected%3Daccount_links_prod)
* *Staging* - [account_links_staging](https://isengard.amazon.com/federate?account=948702324517&role=admin&destination=dynamodb/home%3Fregion%3Dus-west-2%23tables%3Aselected%3Daccount_links_staging)


Monitoring
==========
* [PMET Dashboard](https://w.amazon.com/index.php/Samus/Tech/SamusGateway/Dashboard)
* [Carnaval Alarms](https://carnaval.amazon.com/v1/unifiedSearch.do?namePrefix=samus-alarms.SamusGateway)

SWS Certificate Rotation
========================
[Check here for Permissions and verification steps](https://w.amazon.com/bin/view/Samus/Tech/Boosters/Runbook/TwitchCertificates/)

1. Retrieve private key and certificate from Odin.
    ```
       /apollo/env/envImprovement/bin/odin-get com.amazon.certificates.twitch-prod.amazon.com-STANDARD_SSL_CLIENT_INTERNAL_ENDPOINT-RSA -t PrivateKey -s {insert serial number here} | /apollo/bin/env -e envImprovement openssl pkcs8 -nocrypt -inform DER -outform PEM > key.pem
    ```

    ```
       /apollo/env/envImprovement/bin/odin-get com.amazon.certificates.twitch-prod.amazon.com-STANDARD_SSL_CLIENT_INTERNAL_ENDPOINT-RSA -t Certificate -s {insert serial number here} | /apollo/bin/env -e envImprovement openssl x509 -inform DER > cert.pem
    ```
2. Retrieve corresponding redfort certificate chain.
    - Navigate to the Redfort page for the certificate ([Staging](https://redfort.amazon.com/certificateRecords/72798/certificates/157663) | [Production](https://redfort.amazon.com/certificateRecords/78314))
    - Navigate to certificate ID marked published, select the entire certificate chain, and copy to a new file (chain.pem).
3. Combine the key, cert, and chain into a single file.
    ```
    cat cert.pem key.pem chain.pem > chain_cert_key.pem
    ```
4. Verify your new certificate works by using OpenSSL.
    - Ensure that open ssl can read the private key.
    ```
        /apollo/bin/env -e envImprovement openssl rsa -in chain_cert_key.pem -check
    ```
    - Check the public key information. Should verify that the issuer and validity all make sense.
    ```
        /apollo/bin/env -e envImprovement openssl x509 -in chain_cert_key.pem -text -noout
    ```
5. Upload the new chain_cert_key to Sandstorm
    - Navigate to the [Sandstorm dashboard](https://dashboard.xarth.tv/sandstorm/manage-secrets)
    - Find the correct secret by key.
    - Paste in the new cert contents into the plaintext field and save. **NOTE**: If you have the "do not broadcast" box unchecked, the new cert will be deployed to hosts automatically. 
