API
===
Proxy APIs for interacting with Amazon network Samus services.

## Twitch Prime Status
- **`PrimeStatus`:** Get the specified user's Twitch Prime status
    
#### Request
    **GET** /samus/users/:userId/status

    **GET** /api/users/:userId/samus/status

#### Response
        {
            "twitchUserId": <twitch_user_id>,
            "twitchPrime": false | true,
            "countryCode": <country_code>
        }

## Subscription Credit
- **`SubCreditBalance`:** Get the user's current monthly subscription credit balance
    
#### Request
    **GET** /samus/users/:userId/subscription_credit/balance

    **GET** /api/users/:userId/samus/balance

#### Response
        {
            "subscriptionCreditBalance": 0 | 1
        }
 
- **`CanSpendPrimeCredit`:** Verify that a user can spend his/her monthly subscription credit
    
#### Request
    **GET** /api/users/:userId/samus/credit?productId=:productId

#### Response
        {
            "canSpendPrimeCredit": false | true
        }
        
- **`SpendSubscriptionCredit`:** Spend the user subscription credit on a broadcaster
    
#### Request
    **PUT** /api/users/:userId/subscription_credit/spend/:broadcasterId

#### Response
        {
            "twitchUserId": <twitch_user_id>,
            "broadcasterId": <broadcaster_id>
            "subscriptionCreditBalance": 0 | 1
        }

- **`UnspendSubscriptionCredit`:** Unspend the user's subscription credit on a broadcaster

#### Request
    **DELETE** /api/users/:userId/subscription_credit/spend/:broadcasterId

#### Response
        {
            "transactionId": <transaction_id>
        }

## Prime User Settings
Note: Currently, user settings only include chat notification option (enabled/disabled) for when a subscription credit is spent

- **`GetPrimeSettings`:** Get the settings for a Twitch Prime user
    
#### Request
    **GET** /api/users/:userId/prime/settings
    
#### Response
    	{
    	    "twitchUserId": <twitch_user_id>,
    	    "isSubscriptionMessage": false | true
        }

- **`SetPrimeSettings`:** Set the settings for a Twitch Prime user

#### Request
    **POST** /api/users/:userId/prime/settings

        {
            "isSubscriptionMessage": false | true
        }
        
#### Response
        {
            "twitchUserId": <twitch_user_id>,
            "isSubscriptionMessage": false | true
        }

## Content Offers
- **`GetCurrentPrimeOffers`:** Get the Prime offers for a given date from SamusOfferService
- offerTitle, offerDescription, and contentClaimInstruction may contain HTML to allow special characters to be shown

#### Request
    **GET** /api/prime/offers?countryCode=:countryCode&locale=:locale&dateOverride=:dateOverride

#### Response
        {
            "offerList": [
                {
                    "offerId": <offer_id>,
                    "applicableGame": <applicable_game>,
                    "contentClaimInstruction": <content_claim_instruction>,
                    "contentDeliveryMethod": <content_delivery_method>,
                    "startTime": <start_time>,
                    "endTime": <end_time>,
                    "externalOfferUri": <external_offer_uri>,
                    "offerTitle": <offer_title>,
                    "offerDescription": <offer_description>,
                    "priority": -n .. n,
                    "publisherName": <publisher_name>,
                    "contentCategories": [ <content_category>, ... ],
                    "assets": [
                        {
                            "assetType": <asset_type>,
                            "location": <location>,
                            "location2x": <location_2x>,
                            "mediaType": <media_type>
                        }, ...
                    ]
                    "vendorSkus": [ "<vendor_sku>", ... ] 
                }, ...
            ]
        }

- **`GetCurrentOffersForUser`:** Get the Prime offers for a given date for a given user from SamusOfferService (includes claimed state for the offer)

#### Request
    **GET** /api/prime/offersForUser?countryCode=:countryCode&userID=:userID&locale=:locale&dateOverride=:dateOverride

#### Response
        {
            "offerList": [
                {
                    "offerId": <offer_id>,
                    "applicableGame": <applicable_game>,
                    "contentClaimInstruction": <content_claim_instruction>,
                    "contentDeliveryMethod": <content_delivery_method>,
                    "startTime": <start_time>,
                    "endTime": <end_time>,
                    "externalOfferUri": <external_offer_uri>,
                    "offerTitle": <offer_title>,
                    "offerDescription": <offer_description>,
                    "priority": -n .. n,
                    "publisherName": <publisher_name>,
                    "contentCategories": [ <content_category>, ... ],
                    "assets": [
                        {
                            "assetType": <asset_type>,
                            "location": <location>,
                            "location2x": <location_2x>,
                            "mediaType": <media_type>
                        }, ...
                    ]
                    "vendorSkus": [ "<vendor_sku>", ... ] 
                    "tags": {
                        "AUDIENCE": <AUDIENCE>,
                        "GROUP": <GROUP>
                    }
                    "offerClaimMetadata": {
                        "offerId": <offerId>,
                        "codeValue": <codeValue>,
                        "codeLabel": <codeLabel>
                    }
                    "offerClaimData": <offerClaimData>
                }, ...
            ]
        }

- **`ClaimOffer`:** Claim a Prime Offer for a given user
- offerTitle, and contentClaimInstruction may contain HTML to allow special characters to be shown

#### Request
    **POST** /api/users/:userId/prime/claim/offer/:offerId
        
#### Response
        {
	        "offerClaimCode": <offer_claim_code>,
	        "claimMethod": <claim_method>,
	        "offerId": <offer_id>,
	        "offerTitle": <offer_title>,
	        "offerClaimData": <offer_claim_data>,
	        "contentClaimInstruction": <content_claim_instruction>,
	        "hasEntitlement": false | true,
	        "twitchUserId": <twitch_user_id>,
        }


- **`GetCurrentPrimeOffers`:** Get the Prime entitlement for a given user if they have already claimed the offer
- offerTitle, and contentClaimInstruction may contain HTML to allow special characters to be shown

#### Request
    **GET** /api/users/:userId/prime/claim/offer/:offerId
    
#### Response
        {
            "offerClaimCode": <offer_claim_code>,
            "claimMethod": <claim_method>,
            "offerId": <offer_id>,
            "offerTitle": <offer_title>,
            "offerClaimData": <offer_claim_data>,
            "contentClaimInstruction": <content_claim_instruction>,
            "hasEntitlement": false | true,
            "twitchUserId": <twitch_user_id>,
        }

- Set the Prime Entitlement for a given user. hasEntitlement must be a boolean true/false or the api will return a 400 Bad Request response
- offerTitle, and contentClaimInstruction may contain HTML to allow special characters to be shown

#### Request
    **PUT** /api/users/:userId/prime/claim/offer/:offerId?hasEntitlement=:hasEntitlement
    
#### Response
        {
            "offerClaimCode": <offer_claim_code>,
            "claimMethod": <claim_method>,
            "offerId": <offer_id>,
            "offerTitle": <offer_title>,
            "offerClaimData": <offer_claim_data>,
            "contentClaimInstruction": <content_claim_instruction>,
            "hasEntitlement": false | true,
            "twitchUserId": <twitch_user_id>,
        }

## Dynamic Strings
- Get the promotional (dynamic) strings for a comma separated list of string ids.
Uses `countryCode` and `locale` to choose the most accurate string.
If the `userId` is whitelisted, the `dateOverride` is respected, otherwise it uses `time.Now()`.
    
#### Request
    **GET** api/string?stringIds=:stringIds
                      &countryCode=:countryCode
                      &locale=:locale
                      &userId=:tuid
                      &dateOverride=:dateOverride
    
#### Response
        {
            "dynamicStringMap": { 
                <string_id>: {
                    "id": <id>
                    "text": <text>
                    "externalUrl": <external_url>
                    "isExternalLink": false | true,
                    "isCached": false | true
                }
            }
        }

## Account Linking
- **`CreateAccountLink`:** Create an account link between a user's Twitch account and their external game account.  Returns 409 if a link already exists.
    
#### Request
    **POST** /api/users/:userId/prime/link/:gameName

        {
            "gameAccount": {
                "accountId": <game_account_id>,
                "displayName": <game_account_username>
            }
        }
    
#### Response
        {
            "accountLink": {
                "userId": <user_id>
                "gameAccount": {
                    "accountId": <game_account_id>,
                    "displayName": <game_account_username>,
                    "gameName": <game_name>
                }
            }
        }
        
- **`GetAccountLink`:** Get the linked game account for a user's Twitch account.  Returns 404 if no link exists.
    
#### Request
    **GET** /api/users/:userId/prime/link/:gameName
    
#### Response
        {
            "accountLink": {
                "userId": <user_id>
                "gameAccount": {
                    "accountId": <game_account_id>,
                    "displayName": <game_account_username>,
                    "gameName": <game_name>
                }
            }
        }

- **`DeleteAccountLink`:** Delete the linked game account for a user
    
#### Request
    **DELETE** /api/users/:userId/prime/link/:gameName

#### Response
        {
             "deleted": {
                 "userId": <user_id>
                 "gameAccount": {
                     "accountId": <game_account_id>,
                     "displayName": <game_account_username>,
                     "gameName": <game_name>
                 }
             }
         }

## Account Linking V2
- **`CreateAccountLinkV2`:** Create an account link between a user's Twitch account and their external game account.  Returns 409 if a link already exists.

#### Request
    **POST** /api/v2/users/:userId/prime/link/:vendorName

        {
            "gameAccount": {
                "accountId": <game_account_id>,
                "displayName": <game_account_username>
            }
        }

#### Response
        {
            "accountLink": {
                "userId": <user_id>
                "gameAccount": {
                    "accountId": <game_account_id>,
                    "displayName": <game_account_username>,
                    "gameName": <game_name>
                }
            }
        }

- **`GetAccountLinkV2`:** Get the linked game account by vendor ID  for a user's Twitch account.  Returns 404 if no link exists.

#### Request
    **GET** /api/v2/users/:userId/prime/link/:vendorName

#### Response
        {
            "accountLink": {
                "userId": <user_id>
                "gameAccount": {
                    "accountId": <game_account_id>,
                    "displayName": <game_account_username>,
                    "gameName": <game_name>
                }
            }
        }

- **`DeleteAccountLinkV2`:** Delete the linked game account by vendor ID for a user

#### Request
    **DELETE** /api/v2/users/:userId/prime/link/:vendorName

#### Response
        {
             "deleted": {
                 "userId": <user_id>
                 "gameAccount": {
                     "accountId": <game_account_id>,
                     "displayName": <game_account_username>,
                     "gameName": <game_name>
                 }
             }
         }