package api

import (
	"testing"

	"net/http/httptest"

	"code.justin.tv/common/config"
	"code.justin.tv/samus/gateway/backend"
	samus_config "code.justin.tv/samus/gateway/configuration"
	"code.justin.tv/samus/gateway/metrics"
	"code.justin.tv/samus/gateway/settings"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
)

//TestApi for server instantiation
func TestApi(t *testing.T) {
	Convey("Setup test server", t, func() {
		log.SetLevel(log.DebugLevel)
		b := &backend.BackendMock{}
		metricsConf := &metrics.MetricsConfig{
			MetricsRegion: "PDX",
		}
		configs := samus_config.SamusConfigurations{MetricsConfig: metricsConf}
		config.Register(settings.LoadConfig())
		s, err := NewServer(config.Statsd(), config.RollbarErrorLogger(), b, configs)
		So(err, ShouldBeNil)

		testServer := httptest.NewServer(s)
		defer testServer.Close()
	})
}
