package api

import (
	"net/http"

	. "code.justin.tv/samus/gateway/util"
	log "github.com/sirupsen/logrus"
	"golang.org/x/net/context"
)

func (s *Server) GetDynamicStrings(ctx context.Context, w http.ResponseWriter, r *http.Request) {

	userID := r.URL.Query().Get("userId")

	// userId can be empty, but if not, validate
	if userID != "" {
		validationErrMsg := ValidateTuid(userID)
		if validationErrMsg != nil {
			s.serveError(ctx, w, r, http.StatusBadRequest, validationErrMsg)
			return
		}
	}
	stringIds := r.URL.Query().Get("stringIds")
	countryCode := r.URL.Query().Get("countryCode")
	locale := r.URL.Query().Get("locale")
	dateOverride := r.URL.Query().Get("dateOverride")

	log.Info("Getting dynamic strings: ", stringIds,
		" for userId: ", userID,
		", countryCode: ", countryCode,
		", locale: ", locale,
		", dateOverride: ", dateOverride)

	resp, status, err := s.Backend.GetDynamicStrings(ctx, stringIds, countryCode, locale, userID, dateOverride)
	if err != nil {
		s.serveError(ctx, w, r, status, err)
		return
	}
	s.serveJSON(ctx, w, r, resp)

}
