package api

import (
	"encoding/json"
	"net/http"

	"golang.org/x/net/context"
)

// HealthCheck implements functionality to perform health pings
func (s *Server) HealthCheck(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	err := json.NewEncoder(w).Encode(map[string]string{"status": "OK", "code": "200"})
	if err != nil {
		s.serveError(ctx, w, r, 500, err)
	}
}
