package api

import (
	"net/http"

	. "code.justin.tv/samus/gateway/util"
	log "github.com/sirupsen/logrus"
	"goji.io/pat"
	"golang.org/x/net/context"
)

func (s *Server) PrimeStatus(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	userID := pat.Param(ctx, "userId")
	validationErrMsg := ValidateTuid(userID)
	if validationErrMsg != nil {
		s.serveError(ctx, w, r, http.StatusBadRequest, validationErrMsg)
		return
	}
	log.Info("Checking Prime Status for userId: ", userID)

	resp, status, err := s.Backend.Status(ctx, userID)
	if err != nil {
		s.serveError(ctx, w, r, status, err)
		return
	}
	log.Debug("Prime Status for userID:", resp.UserID+" is: ", resp.TwitchPrime)
	s.serveJSON(ctx, w, r, resp)
}
