package api

import (
	log "github.com/sirupsen/logrus"

	"encoding/json"
	"net/http"

	samus_gateway "code.justin.tv/samus/gateway/client"
	. "code.justin.tv/samus/gateway/util"

	"goji.io/pat"
	"golang.org/x/net/context"
)

func (s *Server) GetPrimeSettings(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	userID := pat.Param(ctx, "userId")
	validationErrMsg := ValidateTuid(userID)
	if validationErrMsg != nil {
		s.serveError(ctx, w, r, http.StatusBadRequest, validationErrMsg)
		return
	}
	log.Info("Getting Prime Settings for userId: ", userID)

	resp, status, err := s.Backend.GetSettings(ctx, userID)
	if err != nil {
		s.serveError(ctx, w, r, status, err)
		return
	}

	s.serveJSON(ctx, w, r, resp)
}

func (s *Server) SetPrimeSettings(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	var body samus_gateway.SetPrimeSettingsRequestBody

	err := json.NewDecoder(r.Body).Decode(&body)
	if err != nil {
		s.serveError(ctx, w, r, 400, err)
	}

	// TODO Note: As for now, we only send the value of the subscription message boolean because it is the only setting for a prime user
	// TODO If more settings are added, make sure to update the backend function with new parameters or modify to intake a struct
	userID := pat.Param(ctx, "userId")
	validationErrMsg := ValidateTuid(userID)
	if validationErrMsg != nil {
		s.serveError(ctx, w, r, http.StatusBadRequest, validationErrMsg)
		return
	}
	log.Info("Setting Prime Settings for userId: ", userID+" and isSubscriptionMessage: ", body.IsSubscriptionMessage)

	resp, status, err := s.Backend.UpdateSettings(ctx, userID, body.IsSubscriptionMessage)
	if err != nil {
		s.serveError(ctx, w, r, status, err)
		return
	}

	s.serveJSON(ctx, w, r, resp)
}
