package backend

import (
	"fmt"
	"net/http"

	nitro "code.justin.tv/samus/nitro/rpc"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
	"golang.org/x/net/context"
)

func (b *Backend) CanSpendPrimeCredit(ctx context.Context, userID string, productID string) (*CanSpendPrimeCreditResponse, int, error) {
	log.Info("Checking Credit Balance for userId:", userID)

	req := &nitro.GetPremiumStatusesRequest{
		TwitchUserID: userID,
	}

	resp, err := b.nitroClient.GetPremiumStatuses(ctx, req)
	if err != nil {
		return nil, 0, errors.Wrapf(err, "Error calling Nitro::GetPremiumStatuses for userID: %v", userID)
	}

	if !resp.HasPrime {
		log.Info("User does not have prime, returning false...")
		return &CanSpendPrimeCreditResponse{CanSpendPrimeCredit: false, WillRenew: false}, http.StatusOK, nil
	}

	balanceReq, err := b.samusSWSClient.NewRequest("GET", fmt.Sprintf("/samus/users/%s/subscription_credit/balance", userID), nil)
	if err != nil {
		return nil, http.StatusInternalServerError, err
	}
	balanceReq.Header.Set(SWSHEADER, SSCSHEADER)
	balanceResponse := BalanceResponse{}
	s, err := sendRequestAndParseResponse(b.samusSWSClient, ctx, balanceReq, &balanceResponse)
	if err != nil {
		return nil, s, err
	}
	hasBalance := balanceResponse.CreditBalance > 0
	willRenew := balanceResponse.WillRenew
	renewalDate := balanceResponse.RenewalDate
	return &CanSpendPrimeCreditResponse{hasBalance, willRenew, renewalDate}, http.StatusOK, nil
}
