package backend

import (
	"testing"

	"code.justin.tv/samus/gateway/clients/mocks"
	nitro "code.justin.tv/samus/nitro/rpc"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"

	"code.justin.tv/common/config"
	"github.com/pkg/errors"
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

func TestGrantPrimeSuccess(t *testing.T) {
	log.SetLevel(log.DebugLevel)
	Convey("When grant prime succeeds", t, func() {
		mockNitroClient := new(mocks.Nitro)

		b := Backend{stats: config.Statsd(),
			nitroClient: mockNitroClient,
		}

		grantResponse := &nitro.GrantPremiumStatusResponse{
			HasPrime: true,
		}

		mockNitroClient.On("GrantPremiumStatus", mock.Anything, mock.Anything).Return(grantResponse, nil)

		resp, err := b.GrantPrime(context.TODO(), userID)
		So(resp.HasPrime, ShouldEqual, true)
		So(err, ShouldBeNil)
	})
}

func TestGrantPrimeFailure(t *testing.T) {
	log.SetLevel(log.DebugLevel)
	Convey("When grant prime fails", t, func() {
		mockNitroClient := new(mocks.Nitro)

		b := Backend{stats: config.Statsd(),
			nitroClient: mockNitroClient,
		}

		mockNitroClient.On("GrantPremiumStatus", mock.Anything, mock.Anything).Return(nil, errors.New("test error"))

		resp, err := b.GrantPrime(context.TODO(), userID)
		So(resp, ShouldBeNil)
		So(err, ShouldNotBeNil)
	})
}

func TestCancelPrimeSuccess(t *testing.T) {
	log.SetLevel(log.DebugLevel)
	Convey("When cancel prime succeeds", t, func() {
		mockNitroClient := new(mocks.Nitro)

		b := Backend{stats: config.Statsd(),
			nitroClient: mockNitroClient,
		}

		cancelResponse := &nitro.CancelPremiumStatusResponse{
			HasPrime: false,
		}

		mockNitroClient.On("CancelPremiumStatus", mock.Anything, mock.Anything).Return(cancelResponse, nil)

		resp, err := b.CancelPrime(context.TODO(), userID)
		So(resp.HasPrime, ShouldBeFalse)
		So(err, ShouldBeNil)
	})
}

func TestCancelPrimeFailure(t *testing.T) {
	log.SetLevel(log.DebugLevel)
	Convey("When cancel prime fails", t, func() {
		mockNitroClient := new(mocks.Nitro)

		b := Backend{stats: config.Statsd(),
			nitroClient: mockNitroClient,
		}

		mockNitroClient.On("CancelPremiumStatus", mock.Anything, mock.Anything).Return(nil, errors.New("test error"))

		resp, err := b.CancelPrime(context.TODO(), userID)
		So(resp, ShouldBeNil)
		So(err, ShouldNotBeNil)
	})
}
