package backend

import (
	"fmt"

	"bytes"

	"golang.org/x/net/context"
)

// SubCreditSpend debits available credit
func (b *Backend) SubCreditSpend(ctx context.Context, userID string, orderID string, jsonStr []byte) (*SubCreditSpendResponse, int, error) {
	req, err := b.samusSWSClient.NewRequest("PUT", fmt.Sprintf("/samus/users/%s/subscription_credit/spend/order/%s", userID, orderID), bytes.NewBuffer(jsonStr))
	if err != nil {
		return nil, 0, err
	}

	req.Header.Set(SWSHEADER, SSCSHEADER)
	spendCreditResponse := SubCreditSpendResponse{}
	s, err := sendRequestAndParseResponse(b.samusSWSClient, ctx, req, &spendCreditResponse)
	if err != nil {
		return nil, s, err
	}
	return &spendCreditResponse, 0, nil
}
