package backend

import (
	"testing"

	"bytes"
	"io/ioutil"
	"net/http"

	"encoding/json"

	"code.justin.tv/common/config"
	"code.justin.tv/samus/gateway/clients/mocks"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

func TestLegacySubscriptionCreditBackend(t *testing.T) {

	log.SetLevel(log.DebugLevel)

	samusSWSClientMock := new(mocks.HttpMock)

	b := Backend{stats: config.Statsd(),
		samusSWSClient: samusSWSClientMock,
	}

	Convey("When Legacy Spend API is successful", t, func() {

		spendCreditResponse := SubCreditSpendResponse{CreditBalance: 0, UserID: userID, TransactionID: TransactionID}
		buf, err := json.Marshal(spendCreditResponse)
		if err != nil {
			log.Debug(err)
		}
		mockedResp := new(http.Response)
		mockedResp.Body = ioutil.NopCloser(bytes.NewBufferString(string(buf[:])))
		mockedResp.StatusCode = http.StatusOK
		samusSWSClientMock.On("Do", mock.Anything, mock.Anything, mock.Anything).Return(mockedResp, nil)

		resp, s, e := b.SubCreditSpend(context.TODO(), userID, userID, []byte("{\"productId\":\"SomeProductId\",\"channels\":[\"channel1\",\"channel2\"]}"))

		So(resp.TransactionID, ShouldEqual, TransactionID)
		So(resp.UserID, ShouldEqual, userID)
		So(resp.CreditBalance, ShouldEqual, 0)
		So(s, ShouldEqual, 0)
		So(e, ShouldBeNil)
	})

}
