package backend

type SpendSubscriptionCreditResponse struct {
	UserID                    string `json:"userId"`
	BroadcasterID             string `json:"broadcasterId"`
	SubscriptionCreditBalance int    `json:"subscriptionCreditBalance"`
}

// BalanceResponse struct for credit balance
type BalanceResponse struct {
	CreditBalance int    `json:"subscriptionCreditBalance"`
	WillRenew     bool   `json:"willRenew"`
	RenewalDate   string `json:"renewalDate"`
}

// SubCreditSpendResponse struct for spend subscription credit token
type SubCreditSpendResponse struct {
	CreditBalance int    `json:"subscriptionCreditBalance"`
	UserID        string `json:"twitchUserId"`
	TransactionID string `json:"transactionId"`
}

// UnspendCreditResponse struct for unspend subscription credit token
type UnspendSubscriptionCreditResponse struct {
	TransactionID string `json:"transactionId"`
}

// CanSpendPrimeCreditResponse for whether the user can spend a credit on a given channel
type CanSpendPrimeCreditResponse struct {
	CanSpendPrimeCredit bool   `json:"canSpendPrimeCredit"`
	WillRenew           bool   `json:"willRenew"`
	RenewalDate         string `json:"renewalDate"`
}

// SQSMessage holds the details of generic SQS message
type SQSMessage struct {
	Type             string `json:"Type"`
	TopicArn         string `json:"TopicArn"`
	Message          string `json:"Message"`
	Timestamp        string `json:"Timestamp"`
	SignatureVersion string `json:"SignatureVersion"`
	Signature        string `json:"Signature"`
	SigningCertURL   string `json:"SigningCertURL"`
	UnsubscribeURL   string `json:"UnsubscribeURL"`
}
