package backend

import (
	"testing"

	"bytes"
	"io/ioutil"
	"net/http"

	"encoding/json"

	"code.justin.tv/common/config"
	payments "code.justin.tv/revenue/payments-service-go-client/client"
	substwirp "code.justin.tv/revenue/subscriptions/twirp"
	"code.justin.tv/samus/gateway/clients"
	"code.justin.tv/samus/gateway/clients/mocks"
	"code.justin.tv/samus/gateway/dynamo"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

func TestUnspendSubscriptionCreditBackend(t *testing.T) {

	log.SetLevel(log.DebugLevel)

	log.SetLevel(log.DebugLevel)

	samusSWSClientMock := new(mocks.HttpMock)
	samusSWSClient2Mock := new(clients.SamusSWSClientMock)
	paymentsMock := new(clients.PaymentsClientMock)
	subsMock := new(clients.SubscriptionsClientMock)
	dynamoMock := new(dynamo.IUserDaoMock)

	b := Backend{stats: config.Statsd(),
		samusSWSClient:        samusSWSClientMock,
		samusSWSClientWrapper: samusSWSClient2Mock,
		userDao:               dynamoMock,
		paymentsClient:        paymentsMock,
		subscriptionsClient:   subsMock,
	}

	Convey("When Unspend API is successful", t, func() {
		product1 := substwirp.Product{
			ShortName: "TEST_SHORTNAME_BLOCKED",
			Price:     499,
			Id:        "689376",
			Tier:      "1000",
		}
		subsResp := substwirp.GetChannelProductsResponse{
			Products: []*substwirp.Product{&product1},
		}
		subsMock.On("GetChannelProducts", mock.Anything, mock.Anything).Return(&subsResp, nil)

		profile := payments.PurchaseProfile{
			ID: 123,
		}
		paymentsMock.On("InternalCompletePurchase", mock.Anything, mock.Anything, mock.Anything, mock.Anything, mock.Anything).Return(&profile, 200, nil)

		unspendCreditResponse := clients.UnspendCreditResponse{TransactionID: TransactionID}
		buf, err := json.Marshal(unspendCreditResponse)
		if err != nil {
			log.Debug(err)
		}
		mockedResp := new(http.Response)
		mockedResp.Body = ioutil.NopCloser(bytes.NewBufferString(string(buf[:])))
		mockedResp.StatusCode = http.StatusOK
		samusSWSClient2Mock.On("UnspendCredit", mock.Anything, mock.Anything).Return(&unspendCreditResponse, nil)

		resp, e := b.UnspendSubscriptionCredit(context.TODO(), userID, broadcasterID)

		So(e, ShouldBeNil)
		So(resp, ShouldNotBeNil)
	})
}
