package backend

import (
	"testing"

	"net/http"

	"bytes"
	"io/ioutil"

	"errors"

	. "github.com/smartystreets/goconvey/convey"
)

func TestRequireOK(t *testing.T) {
	Convey("RequireOK for HTTP Responses ", t, func() {
		resp := http.Response{
			Body:       ioutil.NopCloser(bytes.NewBufferString("Test Req Body")),
			StatusCode: http.StatusOK,
		}

		res, s, err := requireOK(&resp, nil)
		So(res, ShouldNotBeNil)
		So(s, ShouldEqual, http.StatusOK)
		So(err, ShouldBeNil)

		Convey("When there is an error ", func() {

			res, s, err := requireOK(&resp, errors.New("HTTP Error"))
			So(res, ShouldBeNil)
			So(s, ShouldEqual, http.StatusInternalServerError)
			So(err, ShouldNotBeNil)
		})

		Convey("When HTTP Status is http.StatusNotFound ", func() {
			resp := http.Response{
				Body:       ioutil.NopCloser(bytes.NewBufferString("Test Req Body")),
				StatusCode: http.StatusNotFound,
			}

			res, s, err := requireOK(&resp, nil)
			So(res, ShouldBeNil)
			So(s, ShouldEqual, http.StatusNotFound)
			So(err, ShouldNotBeNil)
		})

		Convey("When HTTP Status is http.StatusBadRequest ", func() {
			resp := http.Response{
				Body:       ioutil.NopCloser(bytes.NewBufferString("Test Req Body")),
				StatusCode: http.StatusBadRequest,
			}

			res, s, err := requireOK(&resp, nil)
			So(res, ShouldBeNil)
			So(s, ShouldEqual, http.StatusBadRequest)
			So(err, ShouldNotBeNil)

		})
		Convey(" When HTTP Status is unexpected ", func() {
			resp := http.Response{
				Body:       ioutil.NopCloser(bytes.NewBufferString("Test Req Body")),
				StatusCode: http.StatusGatewayTimeout,
			}

			res, s, err := requireOK(&resp, nil)
			So(res, ShouldBeNil)
			So(s, ShouldEqual, http.StatusBadGateway)
			So(err, ShouldNotBeNil)
		})
	})

}
