package cache

import (
	log "github.com/sirupsen/logrus"

	"gopkg.in/redis.v3"
)

// NewClient creates a Redis client for caching
func NewClient(address string) *redis.Client {
	client := redis.NewClient(&redis.Options{
		Addr: address,
	})

	pong, err := client.Ping().Result()
	log.Info("Redis Client Ping:", pong, err)

	return client
}
