package samus_gateway

// PrimeStatusResponse contains a TwitchUser's prime status and country
type PrimeStatusResponse struct {
	UserID      string `json:"twitchUserId"`
	TwitchPrime bool   `json:"twitchPrime"`
}

// GetBalanceResponse contains a users subscription credit balance
type GetBalanceResponse struct {
	SubscriptionCreditBalance int64 `json:"subscriptionCreditBalance"`
}

// CanSpendPrimeCreditResponse contains a boolean for whether the user can spend their credit on a given channel
// and whether their sub credit will renew
type CanSpendPrimeCreditResponse struct {
	CanSpendPrimeCredit bool   `json:"canSpendPrimeCredit"`
	WillRenew           bool   `json:"willRenew"`
	RenewalDate         string `json:"renewalDate"`
}

// SpendSubscriptionCreditResponse ...
type SpendSubscriptionCreditResponse struct {
	UserID                    string `json:"twitchUserId"`
	BroadcasterID             string `json:"broadcasterId"`
	SubscriptionCreditBalance int64  `json:"subscriptionCreditBalance"`
}

// SpendSubscriptionCreditRequest body
type SpendSubscriptionCreditRequestBody struct {
	ProductID string   `json:"productId"`
	Channels  []string `json:"channels"`
}

// UnspendSubscriptionCreditResponse ...
type UnspendSubscriptionCreditResponse struct {
	TransactionID string `json:"transactionId"`
}

// CurrentPrimeOffersResponse contains current list of Prime Offers that are live
type CurrentPrimeOffersResponse struct {
	PrimeOffers []PrimeOffer `json:"offerList"`
}

// PrimeOffer contains data for a single Prime Offer
type PrimeOffer struct {
	OfferWithClaimData
	ClaimHint ClaimHint `json:"claimHint"`
}

type GetCurrentOffersWithEligibilityResponse struct {
	CurrentOffers []OfferWithEligibility `json:"offerList"`
}

type OfferWithEligibility struct {
	OfferWithNoClaimData
	OfferEligibility OfferEligibility `json:"offerEligibility"`
}

type OfferEligibility struct {
	IsClaimed         bool   `json:"isClaimed"`
	OfferState        string `json:"offerState"`
	CanClaim          bool   `json:"canClaim"`
	PrimeGamingRule   bool   `json:"primeGamingRule"`
	LinkedAccountRule bool   `json:"requiredAccountRule"`
	MarketplaceRule   bool   `json:"marketplaceRule"`
	ClaimLimitRule    bool   `json:"claimLimitRule"`
	OfferWindowRule   bool   `json:"offerWindowRule"`
}
type OrderDocument struct {
	OrderId                             string               `json:"orderId"`
	OrderState                          string               `json:"orderState"`
	OfferId                             string               `json:"offerId"`
	ItemId                              string               `json:"itemId"`
	ItemTitle                           string               `json:"itemTitle"`
	EntitlementId                       string               `json:"entitlementId"`
	OfferCrownCost                      int                  `json:"offerCrownCost"`
	BenefitOwnerCustomerId              string               `json:"benefitOwnerCustomerId"`
	ActingCustomerId                    string               `json:"actingCustomerId"`
	EntitlementAccountList              []EntitlementAccount `json:"entitlementAccountList"`
	EligibilityDetails                  string               `json:"eligibilityDetails"`
	EligibilityCheckDate                string               `json:"eligibilityCheckDate"`
	HerdWorkId                          string               `json:"herdWorkId"`
	AttributionChannel                  string               `json:"attributionChannel"`
	OrderDocumentCreationDate           string               `json:"orderDocumentCreationDate"`
	OrderDocumentLastUpdateDate         string               `json:"orderDocumentLastUpdateDate"`
	OrderDocumentCreationIdempotenceKey string               `json:"orderDocumentCreationIdempotenceKey"`
	VersionNumber                       float64              `json:"versionNumber"`
}

type Inventory struct {
	Entitlements []Entitlement `json:"entitlements"`
}

type Entitlement struct {
	ItemId              string               `json:"itemId"`
	EntitlementId       string               `json:"entitlementId"`
	EntitlementAccounts []EntitlementAccount `json:"entitlementAccounts"`
	EntitlementStatus   string               `json:"entitlementStatus"`
	FulfillmentStatus   string               `json:"fulfillmentStatus"`
	ClaimCode           string               `json:"claimCode"`
	CreatedDate         string               `json:"createdDate"`
	LastUpdatedDate     string               `json:"lastUpdatedDate"`
	Metadata            Metadata             `json:"metadata"`
}

type Metadata struct {
	LegacyProductId                 string `json:"legacyProductId"`
	KeySetTypeId                    string `json:"KeySetTypeId"`
	MarketplaceId                   string `json:"MarketplaceId"`
	ProductInstances                string `json:"ProductInstances"`
	SOSEntitlementFulfillmentStatus string `json:"SOSEntitlementFulfillmentStatus"`
	CatalogOfferId                  string `json:"catalogOfferId"`
	KeySetId                        string `json:"KeySetId"`
	FulfillmentHandledBySES         string `json:"FulfillmentHandledBySES"`
	EncryptedClaimCode              string `json:"EncryptedClaimCode"`
}

type EntitlementAccount struct {
	AccountType string `json:"accountType"`
	AccountId   string `json:"accountId"`
}

// Offer States
const (
	OfferExpired = "EXPIRED"
	OfferLive    = "LIVE"
	OfferFuture  = "FUTURE"
)

// Content Delivery Methods
const (
	ExternalOffer     = "EXTERNAL_OFFER"
	DirectEntitlement = "DIRECT_ENTITLEMENT"
	ClaimCode         = "CLAIM_CODE"
)

type OfferWithClaimData struct {
	OfferID                 string             `json:"offerId"`
	CatalogOfferID          string             `json:"catalogOfferId"`
	ApplicableGame          string             `json:"applicableGame"`
	ContentClaimInstruction string             `json:"contentClaimInstruction"`
	ContentDeliveryMethod   string             `json:"contentDeliveryMethod"`
	StartTime               string             `json:"startTime"`
	EndTime                 string             `json:"endTime"`
	ExternalOfferUri        string             `json:"externalOfferUri"`
	OfferTitle              string             `json:"offerTitle"`
	OfferDescription        string             `json:"offerDescription"`
	Priority                int                `json:"priority"`
	PublisherName           string             `json:"publisherName"`
	ContentCategories       []string           `json:"contentCategories"`
	Assets                  []OfferAsset       `json:"assets"`
	VendorSKUs              []string           `json:"vendorSkus"`
	Tags                    OfferTag           `json:"tags"`
	OfferClaimMetadata      OfferClaimMetadata `json:"offerClaimCode"`
	OfferClaimData          string             `json:"offerClaimData"`
}

type OfferWithNoClaimData struct {
	OfferID                 string       `json:"offerId"`
	CatalogOfferID          string       `json:"catalogOfferId"`
	ApplicableGame          string       `json:"applicableGame"`
	ContentClaimInstruction string       `json:"contentClaimInstruction"`
	ContentDeliveryMethod   string       `json:"contentDeliveryMethod"`
	StartTime               string       `json:"startTime"`
	EndTime                 string       `json:"endTime"`
	ExternalOfferUri        string       `json:"externalOfferUri"`
	OfferTitle              string       `json:"offerTitle"`
	OfferDescription        string       `json:"offerDescription"`
	Priority                int          `json:"priority"`
	PublisherName           string       `json:"publisherName"`
	ContentCategories       []string     `json:"contentCategories"`
	Assets                  []OfferAsset `json:"assets"`
	VendorSKUs              []string     `json:"vendorSkus"`
	Tags                    OfferTag     `json:"tags"`
}

type ClaimHint string

const (
	Available                  ClaimHint = "AVAILABLE"
	ClaimedNoConflicts         ClaimHint = "CLAIMED_NO_CONFLICTS"
	ClaimedAmazonLinkConflict  ClaimHint = "CLAIMED_AMAZON_LINK_CONFLICT"
	ReclaimableNoConflicts     ClaimHint = "RECLAIMABLE_NO_CONFLICTS"
	ClaimedByMemberOfHousehold ClaimHint = "CLAIMED_BY_MEMBER_OF_HOUSEHOLD"
	NeedPrime                  ClaimHint = "NEED_PRIME"
	OfferFullyClaimed          ClaimHint = "OFFER_FULLY_CLAIMED"
)

type OfferTag struct {
	Audience string `json:"audience"`
	Group    string `json:"group"`
}

type OfferAsset struct {
	AssetType  string `json:"assetType"`
	Location   string `json:"location"`
	Location2x string `json:"location2x"`
	MediaType  string `json:"mediaType"`
}

// PrimeOfferEntitlementResponse contains data about the users claimed offer entitlement
type PrimeOfferEntitlementResponse struct {
	HasEntitlement     bool               `json:"hasEntitlement"`
	UserID             string             `json:"twitchUserId"`
	OfferClaimMetadata OfferClaimMetadata `json:"offerClaimCode"`
	ClaimMethod        string             `json:"claimMethod"`
	OfferID            string             `json:"offerId"`
	OfferTitle         string             `json:"offerTitle"`
	OfferClaimData     string             `json:"offerClaimData"`
	ClaimInstruction   string             `json:"contentClaimInstruction"`
}

type PlaceOrderRequestBody struct {
	IdempotenceKey     string `json:"idempotenceKey"`
	AttributionChannel string `json:"attributionChannel"`
	DateOverride       string `json:"dateOverride"`
}

// PlaceOrderResponse contains data about the users placed order
type PlaceOrderResponse struct {
	OrderID string `json:"orderId"`
}

// GetOrdersByCustomerResponse contains data the customers orders
type GetOrdersByCustomerResponse struct {
	OrderDocuments []OrderDocument `json:"orderDocuments"`
	NextToken      string          `json:"nextToken"`
}

// ListInventory contains data the customers inventory (code offers included)
type ListInventoryResponse struct {
	Inventory Inventory `json:"inventory"`
	NextToken string    `json:"nextToken"`
}

// OfferClaimMetadata has values returned for claim code metadata
type OfferClaimMetadata struct {
	OfferID   string `json:"offerId"`
	CodeValue string `json:"codeValue"`
	CodeLabel string `json:"codeLabel"`
}

type GetDynamicStringResponse struct {
	DynamicStringMap map[string]DynamicString `json:"dynamicStringMap"`
}

type DynamicString struct {
	ID             string `json:"id"`
	Text           string `json:"text"`
	ExternalUrl    string `json:"externalUrl"`
	IsExternalLink bool   `json:"isExternalLink"`
}

type GameAccount struct {
	AccountID   string `json:"accountId"`
	DisplayName string `json:"displayName"`
}

type GameAccountLink struct {
	UserID      string      `json:"userId"`
	GameAccount GameAccount `json:"gameAccount"`
}

type CreateAccountLinkRequestBody struct {
	GameAccount GameAccount `json:"gameAccount"`
}

type CreateAccountLinkResponse struct {
	AccountLink GameAccountLink `json:"accountLink"`
}

type GetAccountLinkResponse struct {
	AccountLink GameAccountLink `json:"accountLink"`
}

type DeleteAccountLinkResponse struct {
	Deleted *GameAccountLink `json:"deleted"`
}

// PrimeSettings for a Twitch Prime user
type PrimeSettings struct {
	IsSubscriptionMessage bool `json:"isSubscriptionMessage"`
}

// GetPrimeSettingsResponse is the collection of settings for a Twitch Prime user
type GetPrimeSettingsResponse struct {
	UserID                string `json:"twitchUserId"`
	IsSubscriptionMessage bool   `json:"isSubscriptionMessage"`
}

// SetPrimeSettingsRequestBody is the collection of settings to be sent for update
type SetPrimeSettingsRequestBody struct {
	IsSubscriptionMessage bool `json:"isSubscriptionMessage"`
}

// SetPrimeSettingsResponse is the collection of settings for a Twitch user after update
type SetPrimeSettingsResponse struct {
	UserID                string `json:"twitchUserId"`
	IsSubscriptionMessage bool   `json:"isSubscriptionMessage"`
}

// ClearOfferClaimCodeForUserRequest is the information required to clear an offer for a user
type ClearOfferClaimCodeForUserRequest struct {
	UserID        string `json:"twitchUserId"`
	MarketplaceID string `json:"marketplaceId"`
	OfferID       string `json:"offerId"`
	CsAgent       string `json:"csAgent"`
	CsContactID   string `json:"csContactId"`
}

// ClearOfferClaimCodeForUserResponse is the response of the attempt to clear an offer
type ClearOfferClaimCodeForUserResponse struct {
	Success bool `json:"success"`
}
