package mocks

import (
	"io"
	"net/http"

	. "code.justin.tv/common/twitchhttp"
	mock "github.com/stretchr/testify/mock"
	context "golang.org/x/net/context"
)

// HttpMock provides mocked interface to test HTTP calls to either Samus or Entitlements
type HttpMock struct {
	mock.Mock
}

// Do executes a requests using the given Context for Trace support
func (h *HttpMock) Do(ctx context.Context, req *http.Request, opts ReqOpts) (*http.Response, error) {

	args := h.Called(ctx, req, opts)
	var resp *http.Response
	if args.Get(0) != nil {
		resp = args.Get(0).(*http.Response)
	}
	return resp, nil
}

// NewRequest creates an *http.Request using the configured host as the base for the path.
func (h *HttpMock) NewRequest(method string, path string, body io.Reader) (*http.Request, error) {
	return http.NewRequest(method, "mocked/path", body)
}
