package mocks

import (
	"io"
	"net/http"
	"time"

	mock "github.com/stretchr/testify/mock"
)

// HttpMock provides mocked interface to test HTTP calls to either Samus or Entitlements
type SigV4SignerMock struct {
	mock.Mock
}

func (s *SigV4SignerMock) Sign(r *http.Request, body io.ReadSeeker, service, region string, signTime time.Time) (http.Header, error) {
	args := s.Called(r, body, service, region, signTime)

	res := args.Get(0).(http.Header)
	err := args.Error(1)

	return res, err
}
