package clients

import (
	"code.justin.tv/foundation/twitchclient"
	payments "code.justin.tv/revenue/payments-service-go-client/client"
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

type PaymentsClientMock struct {
	mock.Mock
}

func (sc *PaymentsClientMock) InternalCompletePurchase(ctx context.Context, userID string, productShortName string, request InternalCompletePurchaseRequest, reqOpts *twitchclient.ReqOpts) (*payments.PurchaseProfile, int, error) {
	args := sc.Called(ctx, userID, productShortName, request, reqOpts)

	res := args.Get(0).(*payments.PurchaseProfile)
	statusCode := args.Int(1)
	err := args.Error(2)

	return res, statusCode, err
}

func (sc *PaymentsClientMock) CancelPurchase(ctx context.Context, userID string, productShortName string, request payments.CancelPurchaseRequest, reqOpts *twitchclient.ReqOpts) error {
	args := sc.Called(ctx, userID, productShortName, request, reqOpts)

	err := args.Error(0)

	return err
}
