package clients

import (
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

type SamusSWSClientMock struct {
	mock.Mock
}

func (sc *SamusSWSClientMock) SpendCredit(ctx context.Context, spendCreditRequest *SpendCreditRequest) (*SpendCreditResponse, error) {
	args := sc.Called(ctx, spendCreditRequest)

	res := args.Get(0).(*SpendCreditResponse)
	err := args.Error(1)

	return res, err
}

func (sc *SamusSWSClientMock) UnspendCredit(ctx context.Context, unspendCreditRequest *UnspendCreditRequest) (*UnspendCreditResponse, error) {
	args := sc.Called(ctx, unspendCreditRequest)

	res := args.Get(0).(*UnspendCreditResponse)
	err := args.Error(1)

	return res, err
}
