package clients

import (
	"net/http"
	"testing"

	"code.justin.tv/samus/gateway/clients/mocks"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"

	"bytes"
	"encoding/json"
	"io/ioutil"

	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

func TestSamusSWSClient(t *testing.T) {

	Convey("When SpendCredit works", t, func() {
		log.SetLevel(log.DebugLevel)

		tcMock := new(mocks.HttpMock)

		samusSWSClient := &SamusSWSClient{tcMock}
		So(samusSWSClient, ShouldNotBeNil)

		expectedSpendCreditResponse := SpendCreditResponse{
			UserID:         "123",
			TransactionID:  "888",
			CreditBalance:  0,
			PurchaseRegion: "US",
		}
		buf, err := json.Marshal(expectedSpendCreditResponse)
		if err != nil {
			log.WithError(err)
		}
		mockRes := new(http.Response)
		mockRes.Body = ioutil.NopCloser(bytes.NewBufferString(string(buf[:])))
		mockRes.StatusCode = http.StatusOK

		tcMock.On("Do", mock.Anything, mock.Anything, mock.Anything).Return(mockRes, nil)

		spendCreditRequest := SpendCreditRequest{
			UserID:        "123",
			ProductID:     "321",
			OrderID:       "888",
			TransactionID: "888",
			Channels:      nil,
		}

		receivedSpendCreditResponse, e := samusSWSClient.SpendCredit(context.TODO(), &spendCreditRequest)

		So(e, ShouldBeNil)
		So(receivedSpendCreditResponse.UserID, ShouldEqual, expectedSpendCreditResponse.UserID)
		So(receivedSpendCreditResponse.TransactionID, ShouldEqual, expectedSpendCreditResponse.TransactionID)
		So(receivedSpendCreditResponse.CreditBalance, ShouldEqual, expectedSpendCreditResponse.CreditBalance)
		So(receivedSpendCreditResponse.PurchaseRegion, ShouldEqual, expectedSpendCreditResponse.PurchaseRegion)
	})

}
