package clients

import (
	substwirp "code.justin.tv/revenue/subscriptions/twirp"
	"github.com/stretchr/testify/mock"
	"golang.org/x/net/context"
)

type SubscriptionsClientMock struct {
	mock.Mock
}

func (sc *SubscriptionsClientMock) GetChannelProducts(c context.Context, r *substwirp.GetChannelProductsRequest) (*substwirp.GetChannelProductsResponse, error) {
	args := sc.Called(c, r)

	res := args.Get(0).(*substwirp.GetChannelProductsResponse)
	err := args.Error(1)

	return res, err
}

func (sc *SubscriptionsClientMock) CreateChatNotificationToken(c context.Context, u string, p string) (*substwirp.CreateChatNotificationTokenResponse, error) {
	args := sc.Called(c, u, p)

	res := args.Get(0).(*substwirp.CreateChatNotificationTokenResponse)
	err := args.Error(1)

	return res, err
}

func (sc *SubscriptionsClientMock) GetPaidUpgrades(c context.Context, r *substwirp.GetPaidUpgradesRequest) (*substwirp.GetPaidUpgradesResponse, error) {
	args := sc.Called(c, r)

	res := args.Get(0).(*substwirp.GetPaidUpgradesResponse)
	err := args.Error(1)

	return res, err
}
