package clients

import (
	"bytes"
	"fmt"
	"io"
	"net/http"

	log "github.com/sirupsen/logrus"
)

func closeBody(body io.ReadCloser) {
	err := body.Close()
	if err != nil {
		log.WithError(err)
	}
}

// requireOK is used to wrap Do and check for a http.StatusOK
func requireOK(resp *http.Response, e error) (*http.Response, int, error) {
	//log.Debug("Validating Response: ", resp)
	log.Debug("Validating error: ", e)

	// Check if there was an error on the wire call
	if e != nil {
		if resp != nil {
			closeBody(resp.Body)
		}
		return nil, http.StatusInternalServerError, e
	}

	// If call was okay but it was not a 200
	if resp.StatusCode != http.StatusOK {
		var buf bytes.Buffer
		status := http.StatusBadGateway
		if _, err := io.Copy(&buf, resp.Body); err != nil {
			return nil, status, err
		}
		defer closeBody(resp.Body)

		if resp.StatusCode == http.StatusBadRequest {
			status = http.StatusBadRequest
		}
		if resp.StatusCode == http.StatusNotFound {
			status = http.StatusNotFound
		}
		return nil, status, fmt.Errorf("%s", buf.Bytes())

	}
	return resp, http.StatusOK, nil
}

func safeClose(resp *http.Response, err *error) {
	if resp != nil {
		if cerr := resp.Body.Close(); cerr != nil && *err == nil {
			*err = cerr
		}
	}
}
