package clients

import (
	voyagertwirp "code.justin.tv/amzn/TwitchVoyagerTwirp"
	twitchConfig "code.justin.tv/common/config"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/samus/gateway/settings"

	"golang.org/x/net/context"
)

const (
	VoyagerEndpoint = "VoyagerEndpoint"
)

// Development Environment config
var DevelopmentVoyagerConfig = map[string]string{
	VoyagerEndpoint: "https://us-west-2.beta.voyager.s.twitch.a2z.com",
}

// Staging Environment config
var StagingVoyagerConfig = map[string]string{
	VoyagerEndpoint: "https://us-west-2.beta.voyager.s.twitch.a2z.com",
}

// Production Environment config
var ProductionVoyagerConfig = map[string]string{
	VoyagerEndpoint: "https://us-west-2.prod.voyager.s.twitch.a2z.com",
}

// Redefine voyagertwirp.Subscription function so we can mock.
type VoyagerClienter interface {
	GetUserChannelSubscriptionWithPaymentsData(context.Context, *voyagertwirp.GetUserChannelSubscriptionWithPaymentsDataRequest) (*voyagertwirp.GetUserChannelSubscriptionWithPaymentsDataResponse, error)
}

type VoyagerClient struct {
	voyagertwirp.TwitchVoyager
}

func NewVoyagerClient() (VoyagerClienter, error) {

	conf := settings.GetConfiguration(DevelopmentVoyagerConfig, StagingVoyagerConfig, ProductionVoyagerConfig)

	c := voyagertwirp.NewTwitchVoyagerProtobufClient(conf[VoyagerEndpoint], twitchclient.NewHTTPClient(twitchclient.ClientConf{
		Host:           conf[VoyagerEndpoint],
		TimingXactName: "Voyager-Client",
		Stats:          twitchConfig.Statsd(),
	}))

	return &VoyagerClient{c}, nil
}

// GetUserChannelSubscriptionWithPaymentsData to check if the user has a Paid Subscription
func (sc *VoyagerClient) GetUserChannelSubscriptionWithPaymentsData(ctx context.Context, request *voyagertwirp.GetUserChannelSubscriptionWithPaymentsDataRequest) (*voyagertwirp.GetUserChannelSubscriptionWithPaymentsDataResponse, error) {
	return sc.TwitchVoyager.GetUserChannelSubscriptionWithPaymentsData(ctx, request)
}
