package decorators

import (
	"net/http"

	"code.justin.tv/samus/gateway/api/apidef"
	"goji.io"
	"golang.org/x/net/context"
)

// RequestHandlerAdapter allows us to pass the API name (e.g. "GetPrimeOffers") to Goji to be referenced later along
// with the handler itself.
type RequestHandlerAdapter struct {
	handler     func(context.Context, http.ResponseWriter, *http.Request)
	handlerName apidef.HandlerName
}

// ServeHTTPC wraps the handler's business logic. This is called by Goji.
func (a RequestHandlerAdapter) ServeHTTPC(c context.Context, rw http.ResponseWriter, r *http.Request) {
	a.handler(c, rw, r)
}

// GetHandlerName returns the name of the handler
func (a RequestHandlerAdapter) GetHandlerName() apidef.HandlerName {
	return a.handlerName
}

// NewRequestHandlingAdapter instantiates a new RequestHandlerAdapter
func NewRequestHandlingAdapter(handler func(context.Context, http.ResponseWriter, *http.Request), handlerName apidef.HandlerName) goji.Handler {
	return RequestHandlerAdapter{
		handler:     handler,
		handlerName: handlerName,
	}
}

// DecorateAndAdapt decorates and applies an adapter to the input API handler function
func DecorateAndAdapt(handler func(context.Context, http.ResponseWriter, *http.Request), handlerName apidef.HandlerName) goji.Handler {
	return NewRequestHandlingAdapter(handler, handlerName)
}
