package dynamo

import (
	"github.com/stretchr/testify/mock"
)

/*
  Test objects
*/

type IUserDaoMock struct {
	mock.Mock
}

type IPrimeEntitlementDaoMock struct {
	mock.Mock
}

func (m *IUserDaoMock) GetOrCreate(userId UserId) (*User, error) {
	args := m.Called(userId)
	resp := args.Get(0).(User)
	return &resp, args.Error(1)
}

func (m *IUserDaoMock) Put(user *User) error {

	args := m.Called(user)
	return args.Error(0)
}

func (m *IUserDaoMock) Delete(userId UserId) error {

	args := m.Called(userId)
	return args.Error(0)
}

func (m *IPrimeEntitlementDaoMock) Get(userID string, offerID string) (*PrimeEntitlement, error) {
	args := m.Called(userID, offerID)
	resp := args.Get(0).(PrimeEntitlement)
	return &resp, args.Error(1)
}

func (m *IPrimeEntitlementDaoMock) Put(entitlement *PrimeEntitlement) error {
	args := m.Called(entitlement)
	return args.Error(0)
}
