package dynamo

import (
	"time"

	"github.com/aws/aws-sdk-go/service/dynamodb"
)

type BaseTableName string
type FullTableName string
type NodeJsRecordKeySelector string
type ReadCapacity int64
type WriteCapacity int64

type BaseDynamoTable interface {
	GetNodeJsRecordKeySelector() NodeJsRecordKeySelector
}

type DynamoTable interface {
	BaseDynamoTable
	ConvertAttributeMapToRecord(attributeMap map[string]*dynamodb.AttributeValue) (DynamoTableRecord, error)
}

type DynamoTableRecord interface {
	GetTable() DynamoTable
	NewAttributeMap() map[string]*dynamodb.AttributeValue
	NewItemKey() map[string]*dynamodb.AttributeValue
	GetTimestamp() time.Time
	UpdateWithCurrentTimestamp()
	ApplyTimestamp(timestamp time.Time)
	NewHashKeyEqualsExpression() string
	NewHashKeyExpressionAttributeValues() map[string]*dynamodb.AttributeValue
}

type DynamoScanTable interface {
	BaseDynamoTable
	ConvertScanOutputToRecords(so *dynamodb.ScanOutput) ([]DynamoScanTableRecord, error)
}

type DynamoScanTableRecord interface {
	GetTable() DynamoScanTable
}
