package metrics

import (
	"github.com/aws/aws-sdk-go/aws/credentials"
)

const (
	// SamusGatewayTest is the unit testing configuration, used specifically when unit testing.
	SamusGatewayTest = "UnitTest"
	// SamusGatewayDev is the local configuration, run from developer environments.
	SamusGatewayDev = "Development"
	// SamusGatewayStaging is the Beta EB stage. Used for testing prior to a push to Prod.
	SamusGatewayStaging = "Staging"
	// SamusGatewayProd is the Production EB stage.
	SamusGatewayProd = "Prod"
)

// Config for our metrics
type MetricsConfig struct {
	Environment        string
	ServiceName        string
	Hostname           string
	MetricsRegion      string
	Marketplace        string
	MetricsCredentials *credentials.Credentials
}

// IsProd will return true if the environment is Prod.
func (config *MetricsConfig) IsProd() bool {
	return config.Environment == SamusGatewayProd
}

// IsBeta will return true if the environment is Beta.
func (config *MetricsConfig) IsBeta() bool {
	return config.Environment == SamusGatewayStaging
}

// IsLocal will return true if the environment is Local.
func (config *MetricsConfig) IsLocal() bool {
	return config.Environment == SamusGatewayDev
}

// IsTest will return true if the environment is for unit tests (Test).
func (config *MetricsConfig) IsTest() bool {
	return config.Environment == SamusGatewayTest
}

// GetAwsRegion will return the aws region used by the service.
func (config *MetricsConfig) GetAwsRegion() string {
	return config.Marketplace
}

// GetAwsMetricsCredentials will return the awsCredentials to use to publish metrics.
func (config *MetricsConfig) GetAwsMetricsCredentials() *credentials.Credentials {
	return config.MetricsCredentials
}
