package metrics

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

type statusTypePair struct {
	status             int
	expectedMetricType string
}

var statusToTypeTests = []statusTypePair{
	{200, MetricTypeSuccesses},
	{250, MetricTypeSuccesses},
	{399, MetricTypeClientError},
	{400, MetricTypeClientError},
	{401, MetricTypeClientError},
	{500, MetricTypeServerError},
	{501, MetricTypeServerError},
	{550, MetricTypeServerError},
}

func TestGetMetricTypeFromStatus(t *testing.T) {
	for _, statusTypePair := range statusToTypeTests {
		actualMetricType := statusToMetricType(statusTypePair.status)

		if actualMetricType != statusTypePair.expectedMetricType {
			t.Error("For", statusTypePair.status, "expected", statusTypePair.expectedMetricType, "got", actualMetricType)
		}
	}
}

func TestMetricsConfigEnvironment(t *testing.T) {
	Convey("Testing Environment stage isProd for prod", t, func() {
		metricsConfig := MetricsConfig{
			Environment:   "Prod",
			Hostname:      "test-host",
			ServiceName:   "SamusGateway",
			MetricsRegion: "PDX",
			Marketplace:   "us-west-2",
		}
		isProd := metricsConfig.IsProd()
		So(isProd, ShouldEqual, true)
	})

	Convey("Testing Environment stage isProd for staging", t, func() {
		metricsConfig := MetricsConfig{
			Environment:   "Staging",
			Hostname:      "test-host",
			ServiceName:   "SamusGateway",
			MetricsRegion: "PDX",
			Marketplace:   "us-west-2",
		}
		isProd := metricsConfig.IsProd()
		So(isProd, ShouldEqual, false)
	})
}
