package middleware

import (
	"net/http"

	gorilla "github.com/gorilla/handlers"

	log "github.com/sirupsen/logrus"
)

// AccessLogger emits access_log style logging for every request
// e.g.: 127.0.0.1 - - [30/Nov/2017:12:03:35 -0800] "GET /healthcheck HTTP/1.1" 200 29
func AccessLogger(h http.Handler) http.Handler {
	return gorilla.LoggingHandler(log.StandardLogger().Writer(), h)
}
