package middleware

import (
	"net/http"
)

// Wrapper for http.ResponseWriter that acts as a Middleware to capture HTTP Status Code
type statusRecorderResponseWriter struct {
	http.ResponseWriter
	statusCode int
}

// Creates a new statusRecorderResponseWriter
func NewStatusRecorderResponseWriter(w http.ResponseWriter) *statusRecorderResponseWriter {
	// Initialize with status code of 200 if WriteHeader is never updated or called
	return &statusRecorderResponseWriter{w, http.StatusOK}
}

func (statusRecorder *statusRecorderResponseWriter) WriteHeader(code int) {
	statusRecorder.statusCode = code
	statusRecorder.ResponseWriter.WriteHeader(code)
}
