package promotion_string

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

type DynamoClientConfig struct {
	AwsRegion        string
	TableName        string
	EndpointOverride string
}

type DynamoClient struct {
	Dynamo       *dynamodb.DynamoDB
	ClientConfig *DynamoClientConfig
}

func NewClient(config *DynamoClientConfig) *DynamoClient {
	awsConfig := &aws.Config{
		Region: aws.String(config.AwsRegion),
	}
	dynamo := dynamodb.New(session.New(), awsConfig)
	if config.EndpointOverride != "" {
		dynamo.Endpoint = config.EndpointOverride
	}

	return &DynamoClient{
		Dynamo:       dynamo,
		ClientConfig: config,
	}
}
