package promotion_string

import (
	"github.com/stretchr/testify/mock"
)

/*
  Test objects
*/

type IPromotionStringDaoMock struct {
	mock.Mock
}

type IPromotionStringCacheMock struct {
	mock.Mock
}

func (m *IPromotionStringDaoMock) GetActiveString(stringID string, time string, countryCode string, locale string) (*GetPromotionStringResponse, error) {
	args := m.Called(stringID, time, countryCode, locale)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	resp := args.Get(0).(GetPromotionStringResponse)
	return &resp, args.Error(1)
}

func (m *IPromotionStringDaoMock) GetDefaultString(stringID string, locale string) (*GetPromotionStringResponse, error) {
	args := m.Called(stringID, locale)
	if args.Get(0) == nil {
		return nil, args.Error(1)
	}
	resp := args.Get(0).(GetPromotionStringResponse)
	return &resp, args.Error(1)
}

func (m *IPromotionStringCacheMock) GetPromotionString(key PromotionStringCacheKey) (interface{}, bool) {
	args := m.Called(key)

	var value interface{}
	if args.Get(0) != nil {
		value = args.Get(0).(interface{})
	}

	var found bool
	if args.Get(1) != nil {
		found = args.Get(1).(bool)
	}

	return value, found
}

func (m *IPromotionStringCacheMock) SetPromotionString(key PromotionStringCacheKey, value interface{}) {
}
