package settings

// Development Environment config
var Development = map[string]string{
	SamusSWSHost:               "https://sws-na.amazonpmi.com",
	NumWorkersForSamusSQS:      "0",
	NumWorkersForOrderSQS:      "0",
	RedisHostPort:              "TBD",
	RootCertPath:               "certificates/amazon-ca-certs.pem",
	SamusSWSCertPath:           "/var/app/sws_cert_key_chain",
	SamusStatusQueueName:       "samus-gateway-development",
	SamusOrdersQueueName:       "samus-gateway-orders-staging",
	RailsHost:                  "staging-samus-1-app.dev.us-west2.justin.tv:7000",
	DynamoRegion:               "us-west-2",
	UserDynamoTableName:        "samus_settings_staging",
	EntitlementDynamoTableName: "prime_entitlements_staging",
	PromoStringDynamoTableName: "promotion_strings_staging",
	AccountLinkDynamoTableName: "account_links_staging",
	SnsRegion:                  "us-west-2",
	PrimeStatusSnsTopicArn:     "arn:aws:sns:us-west-2:948702324517:PrimeStatusChangeEvents-Staging",
	NitroEndpoint:              "http://staging-nitro.us-west-2.elasticbeanstalk.com",
	// Metrics
	Environment:   "Development",
	ServiceName:   "SamusGateway",
	Hostname:      "localhost",
	MetricsRegion: "PDX",
	Marketplace:   "us-west-2",
	// Cache Preferences
	OfferCacheExpiration: "30s", // In time.ParseDuration notation https://golang.org/pkg/time/#ParseDuration
	PubSubHost:           "https://darklaunch.pubsub-broker.twitch.a2z.com",
}
