package settings

import (
	"os"
)

// Register a configuration based on environment.
func GetConfiguration(DevelopmentConfig, StagingConfig, ProductionConfig map[string]string) map[string]string {

	environment := os.Getenv("ENVIRONMENT")

	switch environment {
	case "production":
		return ProductionConfig
	case "staging":
		return StagingConfig
	default:
		return DevelopmentConfig
	}

}
