package settings

// Production Environment config
var Production = map[string]string{
	SamusSWSHost:               "https://sws-na.amazon.com",
	NumWorkersForSamusSQS:      "50",
	NumWorkersForOrderSQS:      "50",
	RedisHostPort:              "tbd",
	RootCertPath:               "/var/app/amazon-ca-g3.pem",
	SamusSWSCertPath:           "/var/app/sws_cert_key_chain",
	SamusStatusQueueName:       "samus-gateway-production",
	SamusOrdersQueueName:       "samus-gateway-orders-production",
	RailsHost:                  "api.internal.twitch.tv",
	RollbarToken:               "bcb7753e89894b72a34f818467e3b56f",
	DynamoRegion:               "us-west-2",
	UserDynamoTableName:        "samus_settings_prod",
	EntitlementDynamoTableName: "prime_entitlements_prod",
	PromoStringDynamoTableName: "promotion_strings_prod",
	AccountLinkDynamoTableName: "account_links_prod",
	SnsRegion:                  "us-west-2",
	PrimeStatusSnsTopicArn:     "arn:aws:sns:us-west-2:948702324517:PrimeStatusChangeEvents-Prod",
	NitroEndpoint:              "http://prod-nitro.us-west-2.elasticbeanstalk.com",
	// Metrics
	Environment:   "Prod",
	ServiceName:   "SamusGateway",
	Hostname:      "prod-samus-gateway-env",
	MetricsRegion: "PDX",
	Marketplace:   "us-west-2",
	// Cache Preferences
	OfferCacheExpiration: "5m", // In time.ParseDuration notation https://golang.org/pkg/time/#ParseDuration
	PubSubHost:           "https://prod.pubsub-broker.twitch.a2z.com",
}
