package settings

import (
	"os"

	log "github.com/sirupsen/logrus"
)

//Config constants
const (
	SamusSWSHost               = "SamusSWSHost"
	NumWorkersForSamusSQS      = "NumWorkersForSamusSQS"
	NumWorkersForOrderSQS      = "NumWorkersForOrderSQS"
	RedisHostPort              = "RedisHostPort"
	RootCertPath               = "RootCertPath"
	SamusSWSCertPath           = "SamusSWSCertPath"
	SamusStatusQueueName       = "SamusStatusQueueName"
	SamusOrdersQueueName       = "SamusOrdersQueueName"
	RailsHost                  = "RailsHost"
	RollbarToken               = "RollbarToken"
	DynamoRegion               = "DynamoRegion"
	UserDynamoTableName        = "DynamoTableName"
	EntitlementDynamoTableName = "EntitlementDynamoTableName"
	PromoStringDynamoTableName = "PromoStringDynamoTableName"
	AccountLinkDynamoTableName = "AccountLinkDynamoTableName"
	SnsRegion                  = "SnsRegion"
	PrimeStatusSnsTopicArn     = "PrimeStatusSnsTopicArn"
	NitroEndpoint              = "NitroEndpoint"
	// Metrics
	Environment   = "Environment"
	ServiceName   = "ServiceName"
	Hostname      = "Hostname"
	MetricsRegion = "MetricsRegion"
	Marketplace   = "Marketplace"
	// Caching Preferences
	OfferCacheExpiration = "OfferCacheExpiration"
	PubSubHost           = "PubSubHost"
)

// LoadConfig loads configurations based on environment and returns a map
func LoadConfig() map[string]string {

	environment := os.Getenv("ENVIRONMENT")
	if environment == "" {
		environment = "development"
	}
	if environment == "development" {
		log.Info("Dev Config: ", Development)
		return Development
	} else if environment == "staging" {
		log.Info("Staging Config: ", Staging)
		return Staging
	} else if environment == "production" {
		log.Info("Prod Config: ", Production)
		return Production
	}
	log.Fatal("Environment:", environment, " is not supported")
	return nil
}
