package sns

import (
	"encoding/json"

	"testing"
	"time"

	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/require"

	"github.com/stretchr/testify/mock"
)

//This is an integration test
func TestPublish(t *testing.T) {
	log.SetLevel(log.DebugLevel)
	timestamp := time.Now().UTC().Format(time.RFC3339)
	statusEvent := &StatusEvent{
		TwitchUserID: "118546393",
		HasPrime:     true,
		Timestamp:    timestamp,
	}

	Convey("Samus Publish SNS Message", t, func() {
		jsonBytes, err := json.Marshal(statusEvent)
		require.NoError(t, err)
		eventMessage := string(jsonBytes)
		snsPublisherMock := new(SnsClientMock)
		snsPublisherMock.On("Publish", mock.Anything).Return(nil)
		// Publish SNS Message consumed externally with Prime Status
		err = snsPublisherMock.Publish(eventMessage)
		require.NoError(t, err)
	})
}
