package sns

import (
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/stretchr/testify/mock"
)

/*
  Test objects
*/

type SnsClientMock struct {
	mock.Mock
}

type SNSMock struct {
	mock.Mock
}

func (m *SnsClientMock) Publish(message string) error {
	args := m.Called(message)
	return args.Error(0)
}

func (m *SNSMock) Publish(input *sns.PublishInput) (*sns.PublishOutput, error) {
	args := m.Called(input)
	return nil, args.Error(0)
}
