

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "gateway"
  eb_application_name = "${module.bs-app-gateway.beanstalk_application_name}"
  vpc_id = "vpc-56d38c31"
  ec2_subnet_ids = "subnet-c6f892a1,subnet-1666ea5f,subnet-550aef0e"
  elb_subnet_ids = "subnet-c6f892a1,subnet-1666ea5f,subnet-550aef0e"
  elb_loadbalancer_security_groups = "sg-38ce0043"
  auto_scaling_lc_security_groups = "sg-38ce0043"
  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  auto_scaling_lc_keypair_name = "samus-gateway-stg"
  auto_scaling_lc_instance_type = "m4.xlarge"
  owner = "samus-dev@amazon.com"
  service = "samus/gateway"
  env = "staging"
  associate_public_address = "false"

}
