resource "aws_iam_role" "bs" {
  name = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  path = "/"

  assume_role_policy = <<EOT
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": { "Service": "ec2.amazonaws.com"},
      "Action": "sts:AssumeRole"
    }
  ]
}
EOT
}

resource "aws_iam_role_policy" "bs" {
  name   = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  policy = "${coalesce(var.iam_role_policy, file("${path.module}/files/iam_role"))}"
  role   = "${aws_iam_role.bs.id}"
}

resource "aws_iam_instance_profile" "bs" {
  depends_on = ["aws_iam_role.bs"]
  name       = "${coalesce(var.common_name, null_resource.vars.triggers.cn)}"
  roles      = ["${aws_iam_role.bs.name}"]
}

resource "aws_iam_role_policy_attachment" "ssm_policy_attachment" {
  role       = "${aws_iam_role.bs.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
}