package util

import (
	"regexp"

	"github.com/pkg/errors"
)

// Validates a passed ECID.
func ValidateECID(ecid string) error {
	switch {
	case ecid == "":
		return errors.New("expected non-empty ECID")
	case !isAlphanumeric(ecid):
		return errors.New("expected alphanumeric ECID")
	default:
		return nil
	}
}

func isAlphanumeric(str string) bool {
	alphaNumericRegexp := regexp.MustCompile("^[a-zA-Z0-9_]*$")
	return alphaNumericRegexp.MatchString(str)
}
