package util

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestValidateECID(t *testing.T) {
	Convey("ValidateECID", t, func() {
		Convey("Returns an error if input is empty", func() {
			tuid := ""
			So(ValidateECID(tuid), ShouldNotBeNil)
		})
		Convey("Returns an error if input is not alphanumeric", func() {
			tuid := "1235*"
			So(ValidateECID(tuid), ShouldNotBeNil)
		})

		Convey("Returns no error if input is alphanumeric", func() {
			tuid := "A2U3G50H4W8RC7"
			So(ValidateECID(tuid), ShouldBeNil)
		})
	})
}
