package util

import (
	"github.com/pkg/errors"
	"github.com/satori/go.uuid"
)

func ValidateOffer(offerId string) error {
	_, err := uuid.FromString(offerId)

	if err != nil {
		return errors.Wrapf(err, "OfferId %s is invalid", offerId)
	}

	return nil
}

func ValidateOffers(offerIds ...string) error {
	var validationErr error
	for i, offerId := range offerIds {
		if validationErr = ValidateOffer(offerId); validationErr != nil {
			return errors.Wrapf(validationErr, "OfferId %s at index %d failed validation", offerId, i)
		}
	}
	return nil
}
