package util

/**
 * This file contains all offerIds at the time offerId validation has been added. It is here
 * to ensure that existing offerIds are not seen as invalid by newly added logic. Out of the
 * 352 Beta offerIds and 142 Prod ids in this list, 1 Beta offerId failed validation. That
 * OfferId was longer than a UUID should be and has been removed from the list.
 */

var BetaOfferIds = []string{
	"0eb3c0a0-6d14-bc97-ebd5-2e2c336a5df3",
	"eab5be44-0d6a-e674-0e81-ae100e4d8a2d",
	"b6b528b4-8afe-f7f8-b8d2-71893c621b2b",
	"f2b3b001-d78c-c0f8-1c41-70940bca1faf",
	"1ab5da99-a298-de45-e63e-80494acf3e46",
	"deb5e94d-269e-3d15-800f-dd2d802371df",
	"76b39c56-091b-4069-8a98-09d092555645",
	"ceb4814c-1879-9d5f-cf18-bea3c4f6cf77",
	"00b5da86-0013-a874-7bbb-20057c821833",
	"32b5bb57-edee-8048-02f7-6391965cf0c7",
	"3cb5a72a-712c-0a33-34b6-2063185f10bf",
	"84b5bb57-edd7-5ed0-eee4-8d0e3d2b393a",
	"44b5b34c-9681-fd13-1c67-7f8fcf6b6d6e",
	"d0b5b36c-2e97-d2f4-5b8d-0b2fae6f4eb4",
	"12b39df3-a178-e3b0-5133-ed045f07c03c",
	"62b59744-1841-b7b4-168e-1eab85968320",
	"6eb5a914-bcbe-6964-59a5-378dfc3c1990",
	"b2b4dde6-6e55-4fe1-bfa5-8c46550cea7a",
	"c4b46449-337c-f459-dbac-2a19221eefeb",
	"4eb3c2d9-1137-e878-1d25-efeb2eb0190c",
	"a2b3c02b-772b-ace5-2496-f5c6d0f2c564",
	"5cb2b68e-024e-0c1c-a159-52d8deeabc5e",
	"00b39c56-49d9-d5f8-3d3d-09948a056f37",
	"6cb5951d-e51c-97cb-d5ff-02c227f394af",
	"e8b575b6-5281-4028-d8be-b8b59bd13b07",
	"80b40e24-4d2f-dcf0-7c3f-ea9b0b662c86",
	"8eb367cc-8614-106a-9bfa-f577e2d484f0",
	"aeb3f5f3-11ea-8f91-0863-1a216f9ddf9c",
	"d0b399d7-33f7-359e-ad19-4041c23ffe9a",
	"f2b52894-7032-0c01-2932-47751a73cfa6",
	"a4b5d7ee-107a-64a0-5bd2-735d6754da64",
	"62b53d66-efa9-0ddc-29c1-177cb21bd99f",
	"b4b59507-a548-e074-aaa7-4f3d6d944384",
	"08b5a709-4e09-8021-cf2b-ae8642c433f0",
	"64b5a6d5-034e-88f6-f3a4-1ac48b95521c",
	"98b4dde6-684f-088c-d267-1886d9e4619d",
	"c6b3d414-545d-d512-dfc6-f62023b5916d",
	"6cb414d8-122a-499f-ce09-65e9870e97ce",
	"c4b0feee-c2b5-5f80-664a-be93581ae183",
	"32b59743-a71d-446e-0157-c971c9c8092b",
	"64b5dc6e-d862-af0d-71b0-daf58fe92193",
	"92b44b92-4d42-a1fb-6edc-89deebbcccf0",
	"a4b5473c-9b1f-8427-1f74-90d098f24c96",
	"b4b5da75-87f2-af7d-eed3-a2f5a2315ba0",
	"b4b22410-3816-3152-388c-c1e38e9ce35e",
	"14b5cd53-7880-2570-5499-b08a1d953ba8",
	"eeb31fc8-ab0c-f2d3-7223-406d73fd7d83",
	"8eb597af-2cd6-cc8f-ab62-514dfde42311",
	"44b40db4-e432-d7f7-1d2b-26fc6bfd1690",
	"88b597ac-96a3-b6b6-49ca-28e2021696fd",
	"28b594db-2288-bc6b-7965-0553fed9f14f",
	"04b0feed-4cf9-f15f-3206-f2d189131bbe",
	"dab5dbce-9db1-a6f2-f4a6-3a63259dbeb9",
	"52b4a58d-d6c6-4fc8-2f5c-e5960cf6f35b",
	"72b3c0a0-2b60-e22f-94e2-bf1dba21185d",
	"44b57055-2ce6-bb97-59d5-f144ae4a19e9",
	"c6b5ca6e-d127-e869-5290-ca27a69f0096",
	"0cb4087d-e2d4-6008-0f78-84cc23c804d1",
	"e8b40a29-589c-225e-a13e-f8ff3abc35d0",
	"90b40385-71c1-3e24-2532-b1b1452b0ae6",
	"72b5dcf9-0917-603b-ce05-d20dedfac2d9",
	"56b5b641-d904-0f65-b092-8d1720f30230",
	"3cb40e1a-e630-d24a-20a8-ca9fc61f06de",
	"16b5a6d5-0342-beb6-0e8d-58fbfc2b5a69",
	"dab5cb6c-8870-2b36-f333-abc540169cce",
	"04b5bba6-bf85-5896-1616-be3add1bd3d6",
	"62b5da86-001f-e27e-fc66-61823cb54529",
	"a4b5dcca-a631-3277-9db1-f3c172f80503",
	"9cb53d65-ab76-51e6-6dcb-12c55ede70ac",
	"92b5a6ff-d98e-d116-b824-61a77b57b93c",
	"eeb52894-ab5f-f94e-5589-72b8dcdabd25",
	"aeb40a29-9ab2-3766-6a60-837f3bb2dbe0",
	"f8b5da90-3d2a-b4f2-ee8f-558488fcc1a2",
	"92b5dcca-7b12-d82b-6dc4-d4e563c611f1",
	"b4b5a914-bcad-195f-34f2-122ee08b2d6f",
	"1ab597a2-4e98-c537-8030-0b7a20c4943d",
	"e2b41522-7571-21fb-0540-badf9c662498",
	"48b3a131-4bf8-677c-911d-f0078149b8f2",
	"54b3cd5d-676c-2851-fe03-bdedb87f8f26",
	"78b58596-ace7-464b-fe83-099efe4f52d9",
	"bab399d6-f3ab-5142-24f3-d2fa4c9808b9",
	"aab4ba35-5c2a-ec04-1af7-f8d70f076433",
	"f6b5dcca-7b05-7dcf-caa0-2f3ac19c3c09",
	"26b5a724-8c6e-8611-9f52-c66aedab49c8",
	"1ab5b36c-2e89-7466-d360-78e918504eca",
	"58b5d9d4-3bfc-84fd-147f-39b1becae02a",
	"36b5cd53-788d-1f72-b049-afcc2975829c",
	"1eb4814c-5b63-ef91-6016-778717f50847",
	"66b4beb5-6142-32e9-ced3-04d9d0af4ee5",
	"9cb59784-956b-0586-054b-1cdfb7d8ea76",
	"aeb38ee2-b7f0-9c16-4574-2bb921880df8",
	"26b5a73d-1956-61e3-97db-e086c9974ed2",
	"2ab4beb5-1fba-749a-f94c-5aaec75b4d46",
	"78b5abfa-45aa-020c-5903-7294eafb1409",
	"64b5a724-8c7c-3c7f-3ade-d0b3b22e1b68",
	"acb40385-2d7b-34d4-4522-9d2252e1b8c1",
	"a6b5a73e-8f2b-2a85-f67c-7bf2418b6b4f",
	"3cb4f5d7-ef9e-b33d-da3b-0e2b270eb166",
	"86b414c9-7354-e524-a164-affc860f435f",
	"1ab5a719-b18a-eca6-ee7d-9be332356998",
	"48b20fdb-11a9-f19f-caf2-de04928f58a5",
	"b2b5cd3c-f49d-ae4c-07e0-e1ccb93b3f37",
	"0cb597a5-a19c-ad7b-4bb2-75be0163d905",
	"b0b5da90-3d36-0a32-1577-e4792a2ebd9a",
	"22b59514-c773-ed55-d76b-81b79b8b34ef",
	"44b5979e-e759-65fd-5a81-9687f10c39f6",
	"e6b59506-3c99-a7bd-ccb8-a0a7c4562361",
	"d4b42eed-43ec-90e8-26a0-ad846dbed0a0",
	"78b414d4-b2f5-83e6-debf-dd34764182cb",
	"52b22706-53a0-fc6a-95ca-9c3237d57077",
	"98b22e2c-86fd-b3fe-feb4-2824877ae7ca",
	"28b5e94d-2680-75a5-b866-4f52b1131edf",
	"04b3c02b-34fc-fa5c-3000-ca974305810f",
	"2aad6eb2-fb44-e99d-0a40-26e4ae11c6ec",
	"5eb5da45-8153-5327-df93-e459a372d882",
	"92b4088e-29d6-0420-d3df-76b9700e149b",
	"54b5951b-145c-1572-9fdc-5a16fdbbf12c",
	"8eb5abfa-45b6-d533-9108-cb299cee9166",
	"98b1ded5-539d-dcc7-085b-ad79fd94b917",
	"deb5d058-f1a4-1310-dcd4-61c162c6ea7a",
	"cab1fb2c-03c0-36b1-ee37-698674b92303",
	"06aef3ec-9272-4eba-b50e-cf6e1af165e1",
	"04b43bd4-fe9b-89ca-2825-e86660f42c2a",
	"5cb5da85-5e74-a175-3fc5-16551eb7ec89",
	"3eb5858c-6d0a-e308-b952-3013ee6d447d",
	"16b3b3ba-b21f-76a1-11c9-0746a8439ab3",
	"f6b5da99-a2a5-beb7-76a8-b2f38554d7b5",
	"4eb53d66-f54d-57ec-8377-5838e4705478",
	"00b5a723-9439-5a4b-9fd7-6613c042e455",
	"56b4509f-a616-92ef-9e75-6bcb11ca93b0",
	"70b5a723-c28d-ed73-4d49-efd51315e8f3",
	"f4b5a725-048c-2de4-6844-822677e5a2d9",
	"3cb320c5-9957-e77e-5f50-f81a91ef6bff",
	"f0b5b34c-9692-7b21-a5cd-a791401db773",
	"e4b355cf-624b-0850-9cf9-95a06b72e621",
	"e4b21c73-1de6-5c0d-ba70-b017b51335ad",
	"90b3b3bf-e92a-892d-f946-8f0bfb494f12",
	"7cb30db0-2b2e-197f-3eb3-4c14c42e7773",
	"76b3c0ab-d7ba-1aee-988a-d1f4c274c43e",
	"36b3c2f9-196a-4b31-05d5-ddbb6a9a36cd",
	"0cb5a3fe-5a79-c2ae-a71e-e906255dd696",
	"82b22410-31f0-62f5-020a-8ffbedfa09ab",
	"38b4317b-b8b9-7fe3-cfb0-ce92865b3b5d",
	"f0b5a722-2b16-a0e8-34f4-26b56c301a66",
	"82b5a73d-1936-b507-d86b-862344c49138",
	"f6b5a73e-8f1c-cb35-3fbc-ebb5f7e695c8",
	"30b58597-3e7d-b480-fcdf-d6f383f4f92f",
	"64b594f6-32ad-f510-718a-c6caf38d7234",
	"b4b59507-fb78-b10e-4715-1f7e229fc1ab",
	"aab597a4-6c7f-93e4-19fb-e56c665df9a5",
	"14b5d9d4-3be2-bfb0-c080-6a5fb88f8028",
	"cab5a722-2b0a-9093-03d9-9f34c9863c0f",
	"44b5ca6e-d134-8be7-bdd9-6139fbc4909c",
	"1ab37a17-54a5-7e5d-e74b-afa2b9447b8e",
	"f4b5a723-c2b6-642d-80f3-865c373658c4",
	"aab5d7f7-92af-47d4-1292-6e06c51fb227",
	"f0b5dcd0-6450-1422-2237-b5877520cf97",
	"d8b3a131-9004-949d-c6d9-8146fa08ff71",
	"02b59267-88db-a43b-1ce9-300615d03d4f",
	"1eb4f4c0-ac32-9b8b-c617-2ec44e532374",
	"00b44de5-8d01-05a5-c296-0b0c12a2f9f3",
	"52b5d805-a7fe-c509-0747-e0648bfa170a",
	"12b3c0a4-3644-29f1-ea5f-3ff35a3d251f",
	"26b5b641-d8ef-ebba-929d-fa644a4e38d8",
	"aeb597a8-3022-bb73-391d-e9c239f8e909",
	"8eb59772-c2f3-550b-5425-22e60d9f3b68",
	"d8b31fc8-e96b-e49d-0e3d-9b741038e773",
	"bab5a6ff-d99b-4b87-c135-9ae1cf184872",
	"20b5928c-3117-72b7-36f6-b4108baabb6f",
	"6ab5a725-047c-f299-4254-00082fbc4f35",
	"d2b59522-f386-bd0e-89be-eae5a94e98ea",
	"a6b5d76b-f1e2-ed01-3de4-b59320be0a14",
	"26b30daf-e401-d003-4666-afe9faa13fb8",
	"3cb5dc6e-d852-118e-3265-633c5e084703",
	"d2b53554-bff3-bd5a-fe7b-680adf314824",
	"86b408c2-d76e-3dfd-e87b-e621ce4d699e",
	"eab5c8cc-41e5-f891-5933-62bef42b9bb5",
	"b4b3f5f2-d0e4-bd74-6174-12399767046f",
	"8cb5c807-b563-9f2e-1dc9-b36d28d14aca",
	"42b49341-3e8c-d474-6592-9cc8e28cb705",
	"12b4dde5-6802-9593-b8c3-62804a1283d0",
	"92b4d105-60f2-0d37-6645-2c20efee47f2",
	"22b4747c-6d97-944c-7bcb-3b4a13415c1f",
	"94b5a725-02a0-eb14-17b9-3cc34e3c48b0",
	"c0b3b002-1a5e-2bd7-88f5-64aec812bd76",
	"c8b32ae3-fe0b-d48f-f5cf-43b9cd4d5236",
	"84b57e11-8d5b-72d0-740d-0a05e8ed8fa3",
	"c0b52864-b289-e797-6b49-2a5effcd6574",
	"8ab59784-ba39-805f-0213-b141d1d6673f",
	"84b5dcd0-6442-dc0a-ac1e-ddcbb6f4f826",
	"a0b5b620-b6a0-027d-fc7a-2ab2c4d707a1",
	"7ab528bb-9e3f-a87b-beca-a0702d5de7cb",
	"ecb5bba6-bf78-067f-79a8-cbcb8515108b",
	"10b5da75-87fe-4c02-bab3-faba553d4fef",
	"dab3f81a-8a9a-2837-1306-079148641f66",
	"88b27b38-2972-b2d5-3f6d-27af43357497",
	"ccb3accc-498d-95a8-c2ae-ffaad2bb0b23",
	"40b5dcca-a625-2110-5250-2fdc71eefc0b",
	"48b40e15-a11f-1050-1248-35818c6a21b3",
	"f4b5dcc9-0d2f-aeef-90e9-6ea2e7af1bdd",
	"5cb5a441-73cd-e06f-c852-e73c401e80a7",
	"b4b431b2-0b35-ef10-a645-0b559cd4f644",
	"feb355cf-2147-bb8d-2382-eb8d983d98d3",
	"f6b5dcd7-a8ce-a344-3e6d-4491c66b9c9d",
	"4ab3ade9-dc98-d2cc-0f2e-9c16b2b69da0",
	"62b5da85-5e80-79fc-6a95-5e39e110474d",
	"32b5cb6c-8862-19e6-a79c-3bbf3bebd1df",
	"76b59502-6fa9-71c5-db1f-012468e02ee3",
	"a8b5a725-02ae-a368-5562-47e8d928ffd7",
	"b6b44b56-d93b-b1ea-91f4-dc768fe3c630",
	"10b37864-c974-2e51-4c4a-7ef2078f6f29",
	"32b5a8e7-52bf-0867-9b14-d490037d4a7a",
	"f2b5d7f7-92a1-523e-44de-1e3d0636d6e7",
	"bcb53d64-5d02-c7d1-699c-66655ba77170",
	"c2b3c281-6adf-cfe7-6749-e7def2a67bf0",
	"96b2212e-1ebe-f272-e237-80eec499bc4f",
	"42b5cd01-989d-d625-b385-0d71bcc7b46e",
	"10b59748-71e1-f8e7-8d45-cf037b51a203",
	"34b40e1a-a307-ac34-3d9e-42b51b951489",
	"18b5858a-b030-d990-2082-dbcfd543fb61",
	"b6b5a72a-7120-0600-e8e2-139e0be1f44a",
	"deb5be43-c5d1-d2e8-de94-c67e240442bc",
	"20b59507-fb6d-733e-b3da-5437ae8d2193",
	"4eb53d65-b02a-0fb5-57a3-c7b58bc0c762",
	"16b40adc-34d0-df34-08c1-b92f0d55431d",
	"4eb5d7ee-106b-4ea3-b55f-46c35491a9cb",
	"9ab5a73d-1946-dc45-0054-cb999c75cffc",
	"44b41550-decf-a724-f33c-a4e4c6935c97",
	"d4b1fb2c-0b57-4f1e-7135-3489d075f023",
	"06b5977f-accb-ee69-aed8-d13f32a443fd",
	"36b3c2d8-c81b-7e32-04c2-7c10613b19b9",
	"98b2b68e-0868-a6e4-3e4c-a097efd4046c",
	"88b5977b-ec0d-29f4-1202-6c355b5ef304",
	"d2ad6ed1-93ee-fd99-86db-907dd4a950d0",
	"54b53554-c70c-ee83-2e1c-d7e556faf20b",
	"16b55efd-a3c0-01b9-2488-4fa27cd43966",
	"beb34fb0-d4c1-7b26-c8b8-c00200914d58",
	"80b21c73-2b77-1cd0-aa74-18ae45485dbc",
	"80b559ed-8ee7-9945-a0ca-8ee8f4c8f698",
	"34b331b4-2c34-8822-437f-d26fb2e0d6b4",
	"b6b40db4-a1e3-4659-c48a-9f19956ad003",
	"32b320c0-1bdb-be39-fbbe-8cf2886ee52b",
	"fcb40e0e-4d72-715f-4615-17563fe1aebb",
	"76b57370-cafa-692e-850d-e4491db079ee",
	"e2b431b4-50ef-293b-1f68-25522c48f182",
	"64b59744-184d-69e1-685b-45d5aa08a6ef",
	"dcb5cd01-98ac-7827-9594-8afe9adf9600",
	"6cb59735-5f40-45cf-42e9-08092104fde5",
	"b8b5c8cc-41f4-a2dc-bb21-4ed823bd8e2c",
	"60b5d7fa-b7da-9aa1-d1d3-42727dc176ef",
	"02b5b668-0ac7-769b-eda5-0153d3ee0117",
	"f2b59519-7b2b-8a41-af60-c8edc94cbc1e",
	"dcb5a701-ddf7-5c7c-3194-a728c6f33542",
	"1eb5dcfa-95e9-666b-5b5d-d2c9894b85c0",
	"94b5dcc9-0d20-e3b5-4db7-dcd42e0a78a3",
	"98b597a0-2a2a-b86e-620e-565b40790113",
	"b6b5be6a-84f9-d77e-fae7-ab7f13c3b77d",
	"e2b5a701-dde9-2760-ab3c-2acc7886ca4c",
	"78b5d805-a7eb-bb3b-85b7-0ec873f6b023",
	"4cb5d784-1e37-af28-a4e0-b0eba41d82da",
	"88b5dcf9-090a-5911-76e3-0d2acefa014c",
	"7cb5dcd7-a8c0-e2c8-49e7-fa3734fea523",
	"0cb528bb-5ed9-2986-bfcb-855c141e899d",
	"f2b40e15-6439-301d-195e-c16ee360e320",
	"8ab57054-ea1c-1631-0e4d-bc96cd886a0b",
	"3eb559ea-ed68-1f76-459f-23d331f454bc",
	"3ab5a440-6e00-37b1-aa2e-db679a7a934d",
	"fab3b301-3bda-aeca-8557-e80cfe41654f",
	"48b4a58e-1925-ff9e-5c0a-fd3157564648",
	"22b59249-f241-5776-4f08-65dfd986e19c",
	"2eb5d78b-b893-d1c5-fb89-4b25ceb53b53",
	"feb59503-75c0-f56c-7b10-e887abeaf290",
	"32b59743-a710-1fe9-fb72-e5055819c8be",
	"a2b37655-a23b-9dbf-6bfb-c5da1357eb53",
	"10b5a719-b198-6c91-dc78-84b301690a53",
	"96b4b797-29ea-7e77-eff3-f6655cbad88c",
	"f0b5951d-e52d-ec38-02d1-8b9dfa9f24d4",
	"44b5d784-1e49-4e09-bedd-d8c8171f84d8",
	"fab59502-6fb7-7806-9223-23307f900f2d",
	"74b49341-7fac-0b2d-4430-53bbfc6bc0d9",
	"e8b3f134-4bfb-ceed-c5b8-16ac7fd438e2",
	"f2b3c0ab-9532-890f-3890-6f0212aae032",
	"2ab3b3bf-a93e-7f0c-12c1-5e5721674334",
	"0cb5d76b-f1ef-9cef-75dc-27d0987cf7f4",
	"70b408c3-18d5-7709-256f-2b257076fa8b",
	"e6b3b301-78c1-0c91-dde4-ad85a8a18908",
	"68b40815-e796-7d92-9dcf-4bf46483b898",
	"12b3f81a-ce68-dbab-a1f3-ebffd93fc54b",
	"68b5a709-4e15-f808-bb80-0ddad2e2df38",
	"84b48b98-d0ad-8a7b-b0ca-319254721a8e",
	"3eb34f36-bc20-3815-a47c-4aa4021aad54",
	"90b22e2c-8c97-d726-66f5-d7d398f42809",
	"c6b5d78b-b8a3-dd7e-b18a-fc58c480e955",
	"46b5dcfa-95f9-f429-649a-24fb17925a86",
	"8eb4b796-e2ef-eab4-e2dc-524e766fa481",
	"c4b3adea-1d9a-c4e0-12f6-62a10fa4183d",
	"b2b59506-3c8b-ccb0-f7c9-75e666bc1a47",
	"56b5d058-f1b2-2f98-e2b7-85946814290a",
	"52b563c7-ea97-61cc-342b-506d391c0568",
	"00b5b78d-3ef8-e510-59b8-bf4643dfd361",
	"48b34479-b993-a021-d4c7-4153a632ac07",
	"88b528b4-c7c0-4917-908c-8a0fda177c43",
	"fab575b6-568b-4197-33ba-df156b5a8aab",
	"82b41551-20f0-a51c-96c0-eedfe8f74a6d",
	"c0b45098-483e-f6d2-b957-2590c792bab3",
	"a2b5a492-1fba-d8a8-56f0-b473dcffb3f2",
	"02b5dbce-9da1-bb01-9ba9-928ca2d914b0",
	"f6b42eee-b796-78a5-d8bd-dde562959f6d",
	"e6af1a79-68ea-7d3b-6d18-cea6352ca6c2",
	"f8b5b78d-3f06-4629-5244-ee6d4fe5e486",
	"64b5a8e7-5aaa-d29a-9d3a-c0c9fd63ea8d",
	"22b5979d-88de-a73d-aaab-ad9de2888687",
	"76b594f7-4a7d-f09e-18bd-2f594e3854d2",
	"9cb5a723-942b-5972-f749-4a131924aa1e",
	"0ab506d3-b862-2533-c9f2-4853d3e9c0d6",
	"2cb3c0a4-77b2-ddbf-566b-f24a36f493ec",
	"06b5be6a-d030-be85-10e7-34a825f2f931",
	"10b22706-4de2-7e12-c066-4ecb47ee5391",
	"30b58591-c6c1-d028-b94d-75b01ab2234d",
	"b4b5cd3c-f48e-edb6-3447-5d6be43d0ad3",
	"72b5a73e-8f3b-0780-b0c1-86b98b298f9c",
	"3ab5d7fa-b7ce-fe48-0cbc-4e7c6dcd5152",
	"90b55e68-bbc2-12b8-249f-7960edb48798",
	"1eb53d64-57ef-b4e8-8acc-c4e7b3324f06",
	"14b226fb-7530-3a31-a208-bd555b54219b",
	"3ab5979c-1a19-b16c-29f6-36ea0fd346cd",
	"eab509d1-037e-825c-72ec-987ad38e11f1",
	"62b5b668-0ad7-635f-5267-99518be3e625",
	"8cb59799-db8e-004d-ad4d-7bfc8d55fe8d",
	"7eb5951b-146a-0344-931f-03d5d86dcaa1",
	"46b40e24-8a22-fb36-5419-a17e75e604e4",
	"10b320c5-de89-b215-468f-d6f951913cef",
	"f6b559f9-24ce-068c-3111-bc95f7006dd6",
	"bcb5a492-1fac-b937-7618-333b80dab509",
	"c0b597aa-3fbd-676d-d9ba-c69e96718f4e",
	"f0b40e0e-8c28-5e52-715c-da2a1d8970ef",
	"d4b59734-232e-41b5-5da1-e03f1185e8d6",
	"f6b59519-7b39-bffa-860a-b22b2f167a33",
	"eeafbcaa-fda9-27dc-493a-cea7881c590b",
	"eab39df3-e3d8-c030-c431-ac4c917da662",
	"b4b5a3fe-5a98-5e34-f616-70cc68bd9b67",
	"32b5da45-8160-3b26-9ae9-35e1ba728ecc",
	"eab431c4-540a-613f-6bb9-14cdee4788f1",
	"ccb509cf-aa94-4510-bfe3-86ac3caf8d64",
	"6eb3b3ba-72f1-314f-de4b-ca388815a0ac",
	"12b59734-6412-81ab-3398-37b13d78646e",
	"62b48b99-10eb-281a-9570-8e705e20fbf7",
	"e8b226b2-e22d-6937-2545-3ed195ee6eb1",
	"96b40e0e-e74d-2847-d6a8-dadd140237a1",
	"b6b560e6-0ad9-ad3d-c0b0-008b77ae97b0",
	"d4b4622a-c7b9-a4c0-b3bb-dac5ae534eb3",
}

var ProdOfferIds = []string{
	"2eb2312d-c040-056e-8401-ee50c6642e6c",
	"12b46fa5-4c70-05f1-fd82-9c869211b49c",
	"5ab42c45-ec86-86ef-9f5e-67af201dd8c6",
	"14b5ca61-358a-b8f1-0a13-a1167875d73d",
	"e8b5ca63-33d2-e21f-d29e-2e1e31904aa6",
	"52b1edb7-0e08-344d-c45d-5bb4019efafc",
	"3ab5da3c-b955-735f-5d95-341f6b25607c",
	"a0b599cf-d419-8a4c-cc0d-db197c1e60f7",
	"d8b462bd-3e47-3965-e185-c823571fced5",
	"ccb4ce3a-f578-05c7-e422-71f3ac4657f8",
	"7eb5e95f-815e-fc63-cb65-d22edc230637",
	"3cb5bb40-6b0c-f897-d0b9-b4aa5a8816db",
	"eab4890f-a606-fcba-4a73-0a6cbf4a0d84",
	"a6b26eab-4dcd-07d9-935a-13125fc4954e",
	"68b582eb-1b87-0b61-5d5d-753cacc9bbf5",
	"bcb2453e-069a-6102-b73c-3b0e4d63a8e2",
	"36b3bb1d-5722-c40b-979d-a54228ee6b3a",
	"2cb5bd94-4ac2-9d04-69c7-586fd90bf49e",
	"18b511b3-19ed-337e-a635-f13f57420360",
	"2cb4ce39-b038-82cf-e7ca-c69bbfb5b3bf",
	"48b5c55f-f492-e0a2-48db-fa182ec0e9bb",
	"3eb5b3ee-c1ed-aad5-c717-24a006cd72f1",
	"d2b1726e-ebd9-05a2-95ee-9d37fcfd0a8a",
	"00b5926f-2478-f0e6-5df4-b26baf180f47",
	"a0b3ba66-dc08-6a4c-ee09-ad8aee57ed8b",
	"d0b5ccec-a90f-d432-dcc9-140553395fd0",
	"fcb1cc07-84f2-b20d-78b9-ec36f3914f64",
	"dab20f72-0ce2-a85d-4d98-68bd0a580e89",
	"40b2af3a-1988-186b-ff31-a588205d43a7",
	"8ab3bb1f-ea38-bffe-439c-f6278754a03c",
	"54b5922a-8a7e-12bb-2660-944b4725482f",
	"c2b2790e-2d1a-50ea-6897-be5622667a45",
	"ccb21ef3-a8ac-d518-0f67-a7acfe85d8a3",
	"f2b38ca1-fedd-fb5b-39cb-9ffbb96c8e24",
	"8eb5b62d-6543-0cc2-154f-32b589604bd0",
	"90b5ca61-14b5-130f-be69-c3fade0470c4",
	"acb1deac-de4a-03d8-1850-40b774240b7a",
	"7ab582f0-b1b4-c897-c5e9-9c7028d6ba6b",
	"d0b5b3eb-61e5-0293-c5d8-255f4f440389",
	"e0b3e3e2-564a-ca3c-f9fd-0a44a95b9a90",
	"a6b4ce34-eb78-42aa-a36b-1e3c59cea6b1",
	"a4b4ce45-0e40-e47e-4e99-e45870924fca",
	"92b58f54-7816-cc0f-6cac-b2b23d4444d1",
	"22b103e7-245f-edd9-13bf-5bb9d1d36805",
	"86b1de99-6c04-5cec-24dc-8487f93ac4d6",
	"82b38755-f595-eba5-9216-ee1e3c5b65b6",
	"eab2c34e-b218-76dd-af8d-ff5fc2357458",
	"1cb4bc24-9b66-6bf1-2737-fb07297f18c1",
	"92b5b40d-0071-0c59-28d0-a6534578e0eb",
	"2ab52aef-0428-7aa2-f043-d28ce0544fd9",
	"6eb4b787-cbf0-b8c1-8e81-290e11286d55",
	"24b196b3-1cc3-0fca-f51c-6566e837f5fd",
	"8cb46208-a471-2475-51f1-a405a198f0d1",
	"d4b3c564-341c-9f12-3bd5-ef061d2a2201",
	"50b4ce34-08ea-ecd0-dfb5-7b2802f3a00d",
	"9ab4ce37-bb6a-9fad-30c1-775fb1f98510",
	"52b53f6f-a8b4-b1aa-136f-9e6645a7adb8",
	"f2b5803b-af5c-f4e5-7900-7f4a4ee254f0",
	"c4b511c3-44df-298c-2b11-f45ffbccb7f1",
	"3eb3bb22-4816-027f-e109-dafe875bd9e2",
	"34b15dcc-4041-307d-b31c-af5007b7f3df",
	"3cb2312d-c68e-68dd-75ee-09b5d1c6e6cf",
	"20b56677-7f46-4e70-a70e-29361ca72c17",
	"48b26eae-e8b4-90dd-914c-d076ce65c792",
	"84b44d9d-8153-75f2-00d9-46bfaa309d48",
	"8eb2268b-7ca5-bacb-ba28-6d4196656423",
	"54b54f28-1e4b-e43d-66a9-65834a0bbfb3",
	"38b58f4c-f691-900d-695b-c1a656614a1d",
	"bab5dcdc-72bb-a286-8062-ddfcb7d90457",
	"44b007e3-e939-50e9-f110-d3da33b677cd",
	"bab5b5a3-5bfc-3a7d-dbb1-f9bfbaa00001",
	"08b4ce38-9208-90f8-669f-1d9406bd55ee",
	"2eb1faf7-7973-d34a-3267-1485cd601174",
	"04b40b1a-b22f-7df5-06e8-a8f55f401910",
	"a4b5da26-eb8d-7a83-dbdc-4b956517030d",
	"a4b582f4-0555-102c-3994-5d3d0ac5004b",
	"f4b2453d-3ff9-4147-a856-9b2c694b0b97",
	"f4b1deaa-5382-0d66-238a-8fca15a5c89b",
	"8eb4ce35-f5c9-c144-0223-e1ffb644ec7c",
	"5cb2b166-f152-786b-c6bd-f885d83ca38f",
	"c8b181a1-dcf7-563d-9a27-b5d13124547f",
	"e0b1b071-42aa-692a-6f6f-56eec42fedf4",
	"3eb5dce1-b3b3-659e-9be9-16e7b271d4a3",
	"4cb3b3a1-9894-76d2-fc48-6b6168ad03ea",
	"96b1019f-e406-04f7-6af1-5a76f162306b",
	"2cb4cf2c-cd2f-c5e1-bd13-ebb2d1032f2e",
	"a0b21f15-1cda-a532-73c3-9e12bdc9140f",
	"12b582f4-adb6-1476-9984-9b996de32292",
	"c2b41f75-4ce7-1aa3-c667-97c9deef7430",
	"c0b551bb-dc60-00d4-398c-09de60656e6c",
	"30b1138d-0549-40dd-12d4-3062b0dd28dd",
	"12b1f33b-975b-eb52-635b-0437f26dfb83",
	"82b3bd5d-e1d8-6673-95ec-cd1b8902c209",
	"1eb4ce43-e912-a871-7673-fbb453c9b147",
	"a2b5be12-775a-6abf-346f-188a400690ad",
	"a8b5b5a5-19ef-e1f3-8cf7-ba034f286c5e",
	"a8b5b62c-05c1-8712-63fb-4a9e38c2d5ef",
	"86b2f48f-74de-ffb8-0ea9-2bbefbc7d7db",
	"42b32d49-7bda-133c-5b70-035c093ef783",
	"40b5c58c-7896-9c35-15d4-5b3962764390",
	"dab58523-41de-35a0-96ae-f02b21360864",
	"ecb46fa4-5d54-e495-cb0e-e34c58990306",
	"0cb59a1c-c7eb-e257-be4d-4688b3ebf1e9",
	"8cb5d768-2365-491d-e3f8-cff2f56b5d96",
	"3cb21482-5b14-e3cf-b517-6a5ca2559c5d",
	"c6b462ba-dfc2-435e-c8cc-1abf9ec3c425",
	"c6b4ed21-3470-ab32-bcbe-12e06a3c7e0f",
	"b4b53f6b-4b33-0d3e-10bb-5e7c8b0cb1bf",
	"ccb4676a-ad80-9aee-9d71-e13b7adf1d62",
	"54b1019f-e39b-1815-0294-b408d46729b5",
	"7eb1c77b-19de-a9af-93ce-ff694c60659d",
	"a2b58f51-e27e-09a7-f948-e32565b5f011",
	"12b103d6-2f55-47c0-ee17-2d5c4e9b7d60",
	"90b5b62a-ff7f-262d-c13c-ef0da901d9c4",
	"bcb5d729-e505-2567-845b-1e5e2ce130f9",
	"5ab44df7-d749-7881-2473-62b084fb6c11",
	"00b32d0a-b85c-25b2-2e0c-931b0cf6d8c7",
	"b6b5b36e-0f4e-a9fb-ad2f-b9ef363afc3e",
	"ceb2453b-50a8-a953-8160-4a1fbe46fc21",
	"48b4ce46-1d66-690c-ccaf-a0b3d2877b7c",
	"b2b15b75-a493-27e9-bf2b-e0668d658fe6",
	"08b1b582-33c3-ac69-22ff-91e547267a5c",
	"d0b3e1c0-5d7c-2a6a-60e8-8dd9b068b266",
	"b2b4bc24-af4b-9509-7790-38b65a743cac",
	"eeb3dfaf-1986-f460-aa1d-20eab2f46a96",
	"ecb3f635-4cfd-baa8-004d-4a33e8c3dad5",
	"56b4bc24-ad1c-d829-62cf-94f6d580d463",
	"20b1e86e-adf1-78de-3585-8ce226b70af1",
	"bab26eb0-8e44-c2be-4dc8-5611dfd7f2d9",
	"94b582ef-6a95-e3d0-b13d-d1790fe8daaa",
	"0ab5b3e6-97b1-451e-0b81-8505de2a4654",
	"92b5dcf7-055a-5c59-dd97-e02b6f5416cb",
	"62b46fa4-bb59-3e16-c426-a792b20507af",
	"54b5ca60-9a1a-0f53-7f47-ee2157893bc2",
	"38b5b5a6-b050-4dd8-7d6a-7921daabc4bf",
	"ecb15dd9-c713-2994-c219-5da2f96f7c32",
	"aeb551bb-7533-0e54-9003-880746c7711d",
	"e8b00249-32a5-5e4a-14f1-94f09ea3855e",
	"c2b59a22-ef02-98e9-db80-1e5afc8f129e",
	"a0b5b5a7-5b1c-f89e-346f-b62d6b0b5835",
	"4eb53f6c-d954-9e4b-afef-b1a7c41811f2",
	"32ad5a54-6565-6920-74fb-eacc0a27c931",
}
