package util

import (
	"github.com/pkg/errors"
	"strconv"
)

// Validates that a passed TUID is a number.
func ValidateTuid(tuid string) error {
	intTuid, err := strconv.Atoi(tuid)

	switch {
	case tuid == "":
		return errors.New("expected non-empty TUID")
	case err != nil:
		return errors.New("expected numeric TUID")
	case intTuid == 0:
		return errors.New("expected non-zero TUID")
	case intTuid < 0:
		return errors.New("expected non-negative TUID")
	default:
		return nil
	}
}

func ValidateTuids(tuids ...string) error {
	var validationErr error
	for i, tuid := range tuids {
		if validationErr = ValidateTuid(tuid); validationErr != nil {
			return errors.Wrapf(validationErr, "TUID %s at index %d failed validation", tuid, i)
		}
	}
	return nil
}
